/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import sun.security.util.BitArray;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgIdDSA;
import sun.security.x509.X509Key;

public class DSAPublicKey
extends X509Key
implements java.security.interfaces.DSAPublicKey,
Serializable {
    private static final long serialVersionUID = -2994193307391104133L;
    private BigInteger y;

    public DSAPublicKey() {
    }

    public DSAPublicKey(BigInteger y, BigInteger p, BigInteger q, BigInteger g) throws InvalidKeyException {
        this.y = y;
        this.algid = new AlgIdDSA(p, q, g);
        try {
            byte[] keyArray = new DerValue(2, y.toByteArray()).toByteArray();
            this.setKey(new BitArray(keyArray.length * 8, keyArray));
            this.encode();
        }
        catch (IOException e) {
            throw new InvalidKeyException("could not DER encode y: " + e.getMessage());
        }
    }

    public DSAPublicKey(byte[] encoded) throws InvalidKeyException {
        this.decode(encoded);
    }

    @Override
    public DSAParams getParams() {
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)((Object)this.algid);
            }
            AlgorithmParameters algParams = this.algid.getParameters();
            if (algParams == null) {
                return null;
            }
            DSAParameterSpec paramSpec = algParams.getParameterSpec(DSAParameterSpec.class);
            return paramSpec;
        }
        catch (InvalidParameterSpecException e) {
            return null;
        }
    }

    @Override
    public BigInteger getY() {
        return this.y;
    }

    @Override
    public String toString() {
        return "Sun DSA Public Key\n    Parameters:" + this.algid + "\n  y:\n" + Debug.toHexString(this.y) + "\n";
    }

    @Override
    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream in = new DerInputStream(this.getKey().toByteArray());
            this.y = in.getBigInteger();
        }
        catch (IOException e) {
            throw new InvalidKeyException("Invalid key: y value\n" + e.getMessage());
        }
    }
}

