/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import java.nio.file.spi.FileSystemProvider;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import sun.nio.fs.Globs;
import sun.nio.fs.Util;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileStore;
import sun.nio.fs.WindowsFileSystemProvider;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;
import sun.nio.fs.WindowsPathParser;
import sun.nio.fs.WindowsPathType;
import sun.nio.fs.WindowsUserPrincipals;
import sun.nio.fs.WindowsWatchService;
import sun.security.action.GetPropertyAction;

class WindowsFileSystem
extends FileSystem {
    private final WindowsFileSystemProvider provider;
    private final String defaultDirectory;
    private final String defaultRoot;
    private final boolean supportsLinks;
    private final boolean supportsStreamEnumeration;
    private static final Set<String> supportedFileAttributeViews = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("basic", "dos", "acl", "owner", "user")));
    private static final String GLOB_SYNTAX = "glob";
    private static final String REGEX_SYNTAX = "regex";

    WindowsFileSystem(WindowsFileSystemProvider provider, String dir) {
        this.provider = provider;
        WindowsPathParser.Result result = WindowsPathParser.parse(dir);
        if (result.type() != WindowsPathType.ABSOLUTE && result.type() != WindowsPathType.UNC) {
            throw new AssertionError((Object)"Default directory is not an absolute path");
        }
        this.defaultDirectory = result.path();
        this.defaultRoot = result.root();
        GetPropertyAction pa = new GetPropertyAction("os.version");
        String osversion = AccessController.doPrivileged(pa);
        String[] vers = Util.split(osversion, '.');
        int major = Integer.parseInt(vers[0]);
        int minor = Integer.parseInt(vers[1]);
        this.supportsLinks = major >= 6;
        this.supportsStreamEnumeration = major >= 6 || major == 5 && minor >= 2;
    }

    String defaultDirectory() {
        return this.defaultDirectory;
    }

    String defaultRoot() {
        return this.defaultRoot;
    }

    boolean supportsLinks() {
        return this.supportsLinks;
    }

    boolean supportsStreamEnumeration() {
        return this.supportsStreamEnumeration;
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public String getSeparator() {
        return "\\";
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        int drives = 0;
        try {
            drives = WindowsNativeDispatcher.GetLogicalDrives();
        }
        catch (WindowsException x) {
            throw new AssertionError((Object)x.getMessage());
        }
        ArrayList<WindowsPath> result = new ArrayList<WindowsPath>();
        SecurityManager sm = System.getSecurityManager();
        for (int i = 0; i <= 25; ++i) {
            if ((drives & 1 << i) == 0) continue;
            StringBuilder sb = new StringBuilder(3);
            sb.append((char)(65 + i));
            sb.append(":\\");
            String root = sb.toString();
            if (sm != null) {
                try {
                    sm.checkRead(root);
                }
                catch (SecurityException x) {
                    continue;
                }
            }
            result.add(WindowsPath.createFromNormalizedPath(this, root));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new RuntimePermission("getFileStoreAttributes"));
            }
            catch (SecurityException se) {
                return Collections.emptyList();
            }
        }
        return new Iterable<FileStore>(){

            @Override
            public Iterator<FileStore> iterator() {
                return new FileStoreIterator();
            }
        };
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return supportedFileAttributeViews;
    }

    @Override
    public final Path getPath(String first, String ... more) {
        String path;
        if (more.length == 0) {
            path = first;
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(first);
            for (String segment : more) {
                if (segment.length() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append('\\');
                }
                sb.append(segment);
            }
            path = sb.toString();
        }
        return WindowsPath.parse(this, path);
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return LookupService.instance;
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndInput) {
        String expr;
        int pos = syntaxAndInput.indexOf(58);
        if (pos <= 0 || pos == syntaxAndInput.length()) {
            throw new IllegalArgumentException();
        }
        String syntax = syntaxAndInput.substring(0, pos);
        String input = syntaxAndInput.substring(pos + 1);
        if (syntax.equals(GLOB_SYNTAX)) {
            expr = Globs.toWindowsRegexPattern(input);
        } else if (syntax.equals(REGEX_SYNTAX)) {
            expr = input;
        } else {
            throw new UnsupportedOperationException("Syntax '" + syntax + "' not recognized");
        }
        final Pattern pattern = Pattern.compile(expr, 66);
        return new PathMatcher(){

            @Override
            public boolean matches(Path path) {
                return pattern.matcher(path.toString()).matches();
            }
        };
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return new WindowsWatchService(this);
    }

    private static class LookupService {
        static final UserPrincipalLookupService instance = new UserPrincipalLookupService(){

            @Override
            public UserPrincipal lookupPrincipalByName(String name) throws IOException {
                return WindowsUserPrincipals.lookup(name);
            }

            @Override
            public GroupPrincipal lookupPrincipalByGroupName(String group) throws IOException {
                UserPrincipal user = WindowsUserPrincipals.lookup(group);
                if (!(user instanceof GroupPrincipal)) {
                    throw new UserPrincipalNotFoundException(group);
                }
                return (GroupPrincipal)user;
            }
        };

        private LookupService() {
        }
    }

    private class FileStoreIterator
    implements Iterator<FileStore> {
        private final Iterator<Path> roots;
        private FileStore next;

        FileStoreIterator() {
            this.roots = WindowsFileSystem.this.getRootDirectories().iterator();
        }

        private FileStore readNext() {
            assert (Thread.holdsLock(this));
            while (this.roots.hasNext()) {
                WindowsPath root = (WindowsPath)this.roots.next();
                try {
                    root.checkRead();
                }
                catch (SecurityException x) {
                    continue;
                }
                try {
                    WindowsFileStore fs = WindowsFileStore.create(root.toString(), true);
                    if (fs == null) continue;
                    return fs;
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
            return null;
        }

        @Override
        public synchronized boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            this.next = this.readNext();
            return this.next != null;
        }

        @Override
        public synchronized FileStore next() {
            if (this.next == null) {
                this.next = this.readNext();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            FileStore result = this.next;
            this.next = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

