/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jar;

import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.HashMap;
import java.util.jar.JarFile;
import sun.net.util.URLUtil;
import sun.net.www.protocol.jar.URLJarFile;

class JarFileFactory
implements URLJarFile.URLJarFileCloseController {
    private static final HashMap<String, JarFile> fileCache = new HashMap();
    private static final HashMap<JarFile, URL> urlCache = new HashMap();
    private static final JarFileFactory instance = new JarFileFactory();

    private JarFileFactory() {
    }

    public static JarFileFactory getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    URLConnection getConnection(JarFile jarFile) throws IOException {
        URL u;
        JarFileFactory jarFileFactory = instance;
        synchronized (jarFileFactory) {
            u = urlCache.get(jarFile);
        }
        if (u != null) {
            return u.openConnection();
        }
        return null;
    }

    public JarFile get(URL url) throws IOException {
        return this.get(url, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JarFile get(URL url, boolean useCaches) throws IOException {
        JarFile result;
        String host;
        if (url.getProtocol().equalsIgnoreCase("file") && (host = url.getHost()) != null && !host.equals("") && !host.equalsIgnoreCase("localhost")) {
            url = new URL("file", "", "//" + host + url.getPath());
        }
        if (useCaches) {
            JarFileFactory jarFileFactory = instance;
            synchronized (jarFileFactory) {
                result = this.getCachedJarFile(url);
            }
            if (result == null) {
                JarFile local_result = URLJarFile.getJarFile(url, this);
                jarFileFactory = instance;
                synchronized (jarFileFactory) {
                    result = this.getCachedJarFile(url);
                    if (result == null) {
                        fileCache.put(URLUtil.urlNoFragString(url), local_result);
                        urlCache.put(local_result, url);
                        result = local_result;
                    } else if (local_result != null) {
                        local_result.close();
                    }
                }
            }
        } else {
            result = URLJarFile.getJarFile(url, this);
        }
        if (result == null) {
            throw new FileNotFoundException(url.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(JarFile jarFile) {
        JarFileFactory jarFileFactory = instance;
        synchronized (jarFileFactory) {
            URL urlRemoved = urlCache.remove(jarFile);
            if (urlRemoved != null) {
                fileCache.remove(URLUtil.urlNoFragString(urlRemoved));
            }
        }
    }

    private JarFile getCachedJarFile(URL url) {
        SecurityManager sm;
        Permission perm;
        assert (Thread.holdsLock(instance));
        JarFile result = fileCache.get(URLUtil.urlNoFragString(url));
        if (result != null && (perm = this.getPermission(result)) != null && (sm = System.getSecurityManager()) != null) {
            try {
                sm.checkPermission(perm);
            }
            catch (SecurityException se) {
                if (perm instanceof FilePermission && perm.getActions().indexOf("read") != -1) {
                    sm.checkRead(perm.getName());
                }
                if (perm instanceof SocketPermission && perm.getActions().indexOf("connect") != -1) {
                    sm.checkConnect(url.getHost(), url.getPort());
                }
                throw se;
            }
        }
        return result;
    }

    private Permission getPermission(JarFile jarFile) {
        try {
            URLConnection uc = this.getConnection(jarFile);
            if (uc != null) {
                return uc.getPermission();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

