/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import sun.awt.SunToolkit;
import sun.awt.windows.WComponentPeer;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.opengl.WGLGraphicsConfig;

public abstract class WGLSurfaceData
extends OGLSurfaceData {
    protected WComponentPeer peer;
    private WGLGraphicsConfig graphicsConfig;

    private native void initOps(long var1, WComponentPeer var3, long var4);

    @Override
    protected native boolean initPbuffer(long var1, long var3, boolean var5, int var6, int var7);

    protected WGLSurfaceData(WComponentPeer peer, WGLGraphicsConfig gc, ColorModel cm, int type) {
        super(gc, cm, type);
        this.peer = peer;
        this.graphicsConfig = gc;
        long pConfigInfo = gc.getNativeConfigInfo();
        long hwnd = peer != null ? peer.getHWnd() : 0L;
        this.initOps(pConfigInfo, peer, hwnd);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    public static WGLWindowSurfaceData createData(WComponentPeer peer) {
        if (!peer.isAccelCapable() || !SunToolkit.isContainingTopLevelOpaque((Component)peer.getTarget())) {
            return null;
        }
        WGLGraphicsConfig gc = WGLSurfaceData.getGC(peer);
        return new WGLWindowSurfaceData(peer, gc);
    }

    public static WGLOffScreenSurfaceData createData(WComponentPeer peer, Image image, int type) {
        if (!peer.isAccelCapable() || !SunToolkit.isContainingTopLevelOpaque((Component)peer.getTarget())) {
            return null;
        }
        WGLGraphicsConfig gc = WGLSurfaceData.getGC(peer);
        Rectangle r = peer.getBounds();
        if (type == 4) {
            return new WGLOffScreenSurfaceData(peer, gc, r.width, r.height, image, peer.getColorModel(), type);
        }
        return new WGLVSyncOffScreenSurfaceData(peer, gc, r.width, r.height, image, peer.getColorModel(), type);
    }

    public static WGLOffScreenSurfaceData createData(WGLGraphicsConfig gc, int width, int height, ColorModel cm, Image image, int type) {
        return new WGLOffScreenSurfaceData(null, gc, width, height, image, cm, type);
    }

    public static WGLGraphicsConfig getGC(WComponentPeer peer) {
        if (peer != null) {
            return (WGLGraphicsConfig)peer.getGraphicsConfiguration();
        }
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = env.getDefaultScreenDevice();
        return (WGLGraphicsConfig)gd.getDefaultConfiguration();
    }

    public static native boolean updateWindowAccelImpl(long var0, WComponentPeer var2, int var3, int var4);

    public static class WGLOffScreenSurfaceData
    extends WGLSurfaceData {
        private Image offscreenImage;
        private int width;
        private int height;

        public WGLOffScreenSurfaceData(WComponentPeer peer, WGLGraphicsConfig gc, int width, int height, Image image, ColorModel cm, int type) {
            super(peer, gc, cm, type);
            this.width = width;
            this.height = height;
            this.offscreenImage = image;
            this.initSurface(width, height);
        }

        @Override
        public SurfaceData getReplacement() {
            return WGLOffScreenSurfaceData.restoreContents(this.offscreenImage);
        }

        @Override
        public Rectangle getBounds() {
            if (this.type == 4) {
                Rectangle r = this.peer.getBounds();
                r.y = 0;
                r.x = 0;
                return r;
            }
            return new Rectangle(this.width, this.height);
        }

        @Override
        public Object getDestination() {
            return this.offscreenImage;
        }
    }

    public static class WGLVSyncOffScreenSurfaceData
    extends WGLOffScreenSurfaceData {
        private WGLOffScreenSurfaceData flipSurface;

        public WGLVSyncOffScreenSurfaceData(WComponentPeer peer, WGLGraphicsConfig gc, int width, int height, Image image, ColorModel cm, int type) {
            super(peer, gc, width, height, image, cm, type);
            this.flipSurface = WGLSurfaceData.createData(peer, image, 4);
        }

        public SurfaceData getFlipSurface() {
            return this.flipSurface;
        }

        @Override
        public void flush() {
            this.flipSurface.flush();
            super.flush();
        }
    }

    public static class WGLWindowSurfaceData
    extends WGLSurfaceData {
        public WGLWindowSurfaceData(WComponentPeer peer, WGLGraphicsConfig gc) {
            super(peer, gc, peer.getColorModel(), 1);
        }

        @Override
        public SurfaceData getReplacement() {
            return this.peer.getSurfaceData();
        }

        @Override
        public Rectangle getBounds() {
            Rectangle r = this.peer.getBounds();
            r.y = 0;
            r.x = 0;
            return r;
        }

        @Override
        public Object getDestination() {
            return this.peer.getTarget();
        }
    }
}

