/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.Objects;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import sun.security.util.Debug;
import sun.security.util.ResourcesMgr;

@Deprecated
public abstract class Policy {
    private static Policy policy;
    private static final String AUTH_POLICY = "sun.security.provider.AuthPolicyFile";
    private final AccessControlContext acc = AccessController.getContext();
    private static boolean isCustomPolicy;

    protected Policy() {
    }

    public static Policy getPolicy() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("getPolicy"));
        }
        return Policy.getPolicyNoCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Policy getPolicyNoCheck() {
        if (policy != null) return policy;
        Class<Policy> clazz = Policy.class;
        synchronized (Policy.class) {
            if (policy != null) return policy;
            String policy_class = null;
            policy_class = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return Security.getProperty("auth.policy.provider");
                }
            });
            if (policy_class == null) {
                policy_class = AUTH_POLICY;
            }
            try {
                final String finalClass = policy_class;
                final Policy untrustedImpl = AccessController.doPrivileged(new PrivilegedExceptionAction<Policy>(){

                    @Override
                    public Policy run() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
                        Class<Policy> implClass = Class.forName(finalClass, false, Thread.currentThread().getContextClassLoader()).asSubclass(Policy.class);
                        return implClass.newInstance();
                    }
                });
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() {
                        Policy.setPolicy(untrustedImpl);
                        isCustomPolicy = !finalClass.equals(Policy.AUTH_POLICY);
                        return null;
                    }
                }, Objects.requireNonNull(untrustedImpl.acc));
            }
            catch (Exception e) {
                throw new SecurityException(ResourcesMgr.getString("unable.to.instantiate.Subject.based.policy"));
            }
            return policy;
        }
    }

    public static void setPolicy(Policy policy) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("setPolicy"));
        }
        Policy.policy = policy;
        isCustomPolicy = policy != null;
    }

    static boolean isCustomPolicySet(Debug debug) {
        if (policy != null) {
            if (debug != null && isCustomPolicy) {
                debug.println("Providing backwards compatibility for javax.security.auth.policy implementation: " + policy.toString());
            }
            return isCustomPolicy;
        }
        String policyClass = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty("auth.policy.provider");
            }
        });
        if (policyClass != null && !policyClass.equals(AUTH_POLICY)) {
            if (debug != null) {
                debug.println("Providing backwards compatibility for javax.security.auth.policy implementation: " + policyClass);
            }
            return true;
        }
        return false;
    }

    public abstract PermissionCollection getPermissions(Subject var1, CodeSource var2);

    public abstract void refresh();
}

