/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public abstract class FileSystemProvider {
    private static final Object lock = new Object();
    private static volatile List<FileSystemProvider> installedProviders;
    private static boolean loadingProviders;

    private static Void checkPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("fileSystemProvider"));
        }
        return null;
    }

    private FileSystemProvider(Void ignore) {
    }

    protected FileSystemProvider() {
        this(FileSystemProvider.checkPermission());
    }

    private static List<FileSystemProvider> loadInstalledProviders() {
        ArrayList<FileSystemProvider> list = new ArrayList<FileSystemProvider>();
        ServiceLoader<FileSystemProvider> sl = ServiceLoader.load(FileSystemProvider.class, ClassLoader.getSystemClassLoader());
        for (FileSystemProvider provider : sl) {
            String scheme = provider.getScheme();
            if (scheme.equalsIgnoreCase("file")) continue;
            boolean found = false;
            for (FileSystemProvider p : list) {
                if (!p.getScheme().equalsIgnoreCase(scheme)) continue;
                found = true;
                break;
            }
            if (found) continue;
            list.add(provider);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FileSystemProvider> installedProviders() {
        if (installedProviders == null) {
            FileSystemProvider defaultProvider = FileSystems.getDefault().provider();
            Object object = lock;
            synchronized (object) {
                if (installedProviders == null) {
                    if (loadingProviders) {
                        throw new Error("Circular loading of installed providers detected");
                    }
                    loadingProviders = true;
                    List<FileSystemProvider> list = AccessController.doPrivileged(new PrivilegedAction<List<FileSystemProvider>>(){

                        @Override
                        public List<FileSystemProvider> run() {
                            return FileSystemProvider.loadInstalledProviders();
                        }
                    });
                    list.add(0, defaultProvider);
                    installedProviders = Collections.unmodifiableList(list);
                }
            }
        }
        return installedProviders;
    }

    public abstract String getScheme();

    public abstract FileSystem newFileSystem(URI var1, Map<String, ?> var2) throws IOException;

    public abstract FileSystem getFileSystem(URI var1);

    public abstract Path getPath(URI var1);

    public FileSystem newFileSystem(Path path, Map<String, ?> env) throws IOException {
        throw new UnsupportedOperationException();
    }

    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        if (options.length > 0) {
            for (OpenOption opt : options) {
                if (opt != StandardOpenOption.APPEND && opt != StandardOpenOption.WRITE) continue;
                throw new UnsupportedOperationException("'" + opt + "' not allowed");
            }
        }
        return Channels.newInputStream(Files.newByteChannel(path, options));
    }

    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        int len = options.length;
        HashSet<OpenOption> opts = new HashSet<OpenOption>(len + 3);
        if (len == 0) {
            opts.add(StandardOpenOption.CREATE);
            opts.add(StandardOpenOption.TRUNCATE_EXISTING);
        } else {
            for (OpenOption opt : options) {
                if (opt == StandardOpenOption.READ) {
                    throw new IllegalArgumentException("READ not allowed");
                }
                opts.add(opt);
            }
        }
        opts.add(StandardOpenOption.WRITE);
        return Channels.newOutputStream(this.newByteChannel(path, opts, new FileAttribute[0]));
    }

    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException();
    }

    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract SeekableByteChannel newByteChannel(Path var1, Set<? extends OpenOption> var2, FileAttribute<?> ... var3) throws IOException;

    public abstract DirectoryStream<Path> newDirectoryStream(Path var1, DirectoryStream.Filter<? super Path> var2) throws IOException;

    public abstract void createDirectory(Path var1, FileAttribute<?> ... var2) throws IOException;

    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void createLink(Path link, Path existing) throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract void delete(Path var1) throws IOException;

    public boolean deleteIfExists(Path path) throws IOException {
        try {
            this.delete(path);
            return true;
        }
        catch (NoSuchFileException ignore) {
            return false;
        }
    }

    public Path readSymbolicLink(Path link) throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract void copy(Path var1, Path var2, CopyOption ... var3) throws IOException;

    public abstract void move(Path var1, Path var2, CopyOption ... var3) throws IOException;

    public abstract boolean isSameFile(Path var1, Path var2) throws IOException;

    public abstract boolean isHidden(Path var1) throws IOException;

    public abstract FileStore getFileStore(Path var1) throws IOException;

    public abstract void checkAccess(Path var1, AccessMode ... var2) throws IOException;

    public abstract <V extends FileAttributeView> V getFileAttributeView(Path var1, Class<V> var2, LinkOption ... var3);

    public abstract <A extends BasicFileAttributes> A readAttributes(Path var1, Class<A> var2, LinkOption ... var3) throws IOException;

    public abstract Map<String, Object> readAttributes(Path var1, String var2, LinkOption ... var3) throws IOException;

    public abstract void setAttribute(Path var1, String var2, Object var3, LinkOption ... var4) throws IOException;

    static {
        loadingProviders = false;
    }
}

