/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.ConvertingMethod;
import com.sun.jmx.mbeanserver.MBeanIntrospector;
import com.sun.jmx.mbeanserver.MBeanSupport;
import com.sun.jmx.mbeanserver.MXBeanIntrospector;
import com.sun.jmx.mbeanserver.MXBeanLookup;
import com.sun.jmx.mbeanserver.Util;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class MXBeanSupport
extends MBeanSupport<ConvertingMethod> {
    private final Object lock = new Object();
    private MXBeanLookup mxbeanLookup;
    private ObjectName objectName;

    public <T> MXBeanSupport(T resource, Class<T> mxbeanInterface) throws NotCompliantMBeanException {
        super(resource, mxbeanInterface);
    }

    @Override
    MBeanIntrospector<ConvertingMethod> getMBeanIntrospector() {
        return MXBeanIntrospector.getInstance();
    }

    @Override
    Object getCookie() {
        return this.mxbeanLookup;
    }

    static <T> Class<? super T> findMXBeanInterface(Class<T> resourceClass) {
        String msg;
        if (resourceClass == null) {
            throw new IllegalArgumentException("Null resource class");
        }
        Set<Class<?>> intfs = MXBeanSupport.transitiveInterfaces(resourceClass);
        Set<Class<?>> candidates = Util.newSet();
        for (Class<Object> intf : intfs) {
            if (!JMX.isMXBeanInterface(intf)) continue;
            candidates.add(intf);
        }
        block1: while (candidates.size() > 1) {
            for (Class<Object> intf : candidates) {
                Iterator it = candidates.iterator();
                while (it.hasNext()) {
                    Class intf2 = (Class)it.next();
                    if (intf == intf2 || !intf2.isAssignableFrom(intf)) continue;
                    it.remove();
                    continue block1;
                }
            }
            msg = "Class " + resourceClass.getName() + " implements more than one MXBean interface: " + candidates;
            throw new IllegalArgumentException(msg);
        }
        if (candidates.iterator().hasNext()) {
            return (Class)Util.cast(candidates.iterator().next());
        }
        msg = "Class " + resourceClass.getName() + " is not a JMX compliant MXBean";
        throw new IllegalArgumentException(msg);
    }

    private static Set<Class<?>> transitiveInterfaces(Class<?> c) {
        Set<Class<?>> set = Util.newSet();
        MXBeanSupport.transitiveInterfaces(c, set);
        return set;
    }

    private static void transitiveInterfaces(Class<?> c, Set<Class<?>> intfs) {
        if (c == null) {
            return;
        }
        if (c.isInterface()) {
            intfs.add(c);
        }
        MXBeanSupport.transitiveInterfaces(c.getSuperclass(), intfs);
        for (Class<?> sup : c.getInterfaces()) {
            MXBeanSupport.transitiveInterfaces(sup, intfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(MBeanServer server, ObjectName name) throws InstanceAlreadyExistsException {
        if (name == null) {
            throw new IllegalArgumentException("Null object name");
        }
        Object object = this.lock;
        synchronized (object) {
            this.mxbeanLookup = MXBeanLookup.lookupFor(server);
            this.mxbeanLookup.addReference(name, this.getResource());
            this.objectName = name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister() {
        Object object = this.lock;
        synchronized (object) {
            if (this.mxbeanLookup != null && this.mxbeanLookup.removeReference(this.objectName, this.getResource())) {
                this.objectName = null;
            }
        }
    }
}

