/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.security;

import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.security.SessionManager;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;
import org.springframework.web.util.WebUtils;

@ServletComponentScan
@Component
@WebFilter(urlPatterns={"/*"}, filterName="securityFilter")
@ConditionalOnMissingBean(name={"authFilter"})
public class SecurityFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SecurityFilter.class);
    @Autowired
    private SessionManager sessionManager;
    @Value(value="${security.anon.url:}")
    private String anonUrl;
    @Value(value="${system.language:zh_CN}")
    private String language;
    @Value(value="${system.upload.access:true}")
    private boolean uploadAccess;
    @Value(value="${system.isCloud:false}")
    private Boolean isCloud;
    @Value(value="${system.isReferer:true}")
    private Boolean isReferer;
    @Value(value="${security.allow.method:head}")
    private String allowMethod;
    @Value(value="${system.enableRTL:}")
    private String systemEnableRTL;
    @Value(value="${system.validOnceTime:false}")
    private Boolean validOnceTime;
    @Value(value="${system.frameOptions:}")
    private String frameOptions;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    private static Map<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();

    private boolean doValidOnceTime(HttpServletRequest request) {
        String once;
        if (this.validOnceTime.booleanValue() && !StringUtils.isEmpty((Object)(once = request.getHeader("Once-Time")))) {
            if (this.stringRedisTemplate.opsForValue().get((Object)("system:onceTime:" + once)) != null) {
                return true;
            }
            this.stringRedisTemplate.opsForValue().set((Object)("system:onceTime:" + once), (Object)"1", 30L, TimeUnit.MINUTES);
        }
        return false;
    }

    private boolean isAllowMethod(String method) {
        if (!StringUtils.isEmpty((Object)method)) {
            if (method.equalsIgnoreCase("post") || method.equalsIgnoreCase("get")) {
                return true;
            }
            if (!StringUtils.isEmpty((Object)this.allowMethod)) {
                String[] methods;
                for (String m : methods = this.allowMethod.split(",")) {
                    if (!m.equalsIgnoreCase(method)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public void destroy() {
    }

    protected String getCookie(String name, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public boolean enableRTL(HttpServletRequest request) {
        if (!StringUtils.isEmpty((Object)this.systemEnableRTL) && "true".equalsIgnoreCase(this.systemEnableRTL)) {
            return true;
        }
        String lang = this.getCurrentLanguage(request);
        return !StringUtils.isEmpty((Object)lang) && lang.startsWith("ar");
    }

    private void setRequestParamToAttribute(HttpServletRequest request, String propName) {
        String paramValue = request.getParameter(propName);
        if (StringUtils.isEmpty((Object)paramValue)) {
            paramValue = SpringContextUtil.getApplicationContext().getEnvironment().getProperty("system." + propName);
        }
        if (!StringUtils.isEmpty((Object)paramValue)) {
            request.setAttribute(propName, (Object)paramValue);
        }
    }

    public String getCurrentLanguage(HttpServletRequest request) {
        Cookie cookie;
        String lang = "";
        if (request != null && StringUtils.isEmpty((Object)(lang = request.getParameter("lang"))) && (cookie = WebUtils.getCookie((HttpServletRequest)request, (String)CookieLocaleResolver.LOCALE_REQUEST_ATTRIBUTE_NAME)) != null) {
            lang = cookie.getValue();
        }
        if (StringUtils.isEmpty((Object)lang)) {
            lang = SpringContextUtil.getApplicationContext().getEnvironment().getProperty("system.language");
        }
        return lang;
    }

    public void doFilter(ServletRequest req, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse resp = (HttpServletResponse)response;
        boolean enableRTL = this.enableRTL(request);
        this.setRequestParamToAttribute(request, "leftHide");
        this.setRequestParamToAttribute(request, "topHide");
        this.setRequestParamToAttribute(request, "leftMenuHide");
        this.setRequestParamToAttribute(request, "selectSysCode");
        this.setRequestParamToAttribute(request, "selectMenuId");
        this.setRequestParamToAttribute(request, "structType");
        resp.addHeader("X-XSS-Protection", "1");
        if (!StringUtils.isEmpty((Object)this.frameOptions)) {
            resp.addHeader("X-Frame-Options", this.frameOptions);
        }
        resp.addHeader("Strict-Transport-Security", "max-age=31536000; includeSubDomains; preload");
        String uri = request.getRequestURI();
        log.debug("SecurityFilter URI------->" + uri + ",Http SessionId----------->" + request.getSession().getId());
        String method = request.getMethod();
        if (!this.isAllowMethod(method) || this.doValidOnceTime(request)) {
            log.error("The request with Method[" + method + "] was forbidden by server!");
            resp.setContentType("text/html;charset=UTF-8");
            resp.setCharacterEncoding("UTF-8");
            resp.setStatus(403);
            resp.getWriter().print("<font size=6 color=red>" + I18nUtil.i18nCode((String)"common_req_error_info", (Object[])new Object[0]) + "</font>");
            return;
        }
        if (!(this.isCloud.booleanValue() || !this.isReferer.booleanValue() || uri.contains("portalForgetPwdResetPwd.do") || StringUtils.isEmpty((Object)request.getHeader("Referer")) || StringUtils.isEmpty((Object)request.getServerName()) || !StringUtils.isEmpty((Object)request.getHeader("Is-Client-Dev")) || request.getHeader("Referer").contains(request.getServerName()))) {
            log.error("The request has a diffrent access address with [" + request.getHeader("Referer") + "]");
            resp.setContentType("text/html;charset=UTF-8");
            resp.setCharacterEncoding("UTF-8");
            resp.setStatus(403);
            resp.getWriter().print("<font size=6 color=red>" + I18nUtil.i18nCode((String)"common_req_error_info", (Object[])new Object[0]) + "</font>");
            return;
        }
        String lang = this.getCookie(CookieLocaleResolver.LOCALE_REQUEST_ATTRIBUTE_NAME, request);
        String _lang = request.getParameter("lang");
        req.setAttribute("systemLanguage", (Object)(StringUtils.isEmpty((Object)_lang) ? (StringUtils.isEmpty((Object)lang) ? this.language : lang) : _lang));
        if (SecurityFilter.isAuth(uri)) {
            req.setAttribute("uuid", (Object)UUID.randomUUID().toString().replace("-", ""));
            req.setAttribute("enableRTL", (Object)enableRTL);
            filterChain.doFilter(req, response);
        } else {
            SecuritySubject securitySubject = this.sessionManager.getCurrentSubject(request.getSession().getId());
            String token = request.getParameter("access_token");
            String key = request.getHeader("app_id") == null ? request.getHeader("APP-ID") : request.getHeader("app_id");
            String tokenHeader = request.getHeader("Access-Token");
            boolean allowToken = this.sessionManager.checkToken(token);
            boolean allowKey = this.sessionManager.checkKey(key);
            boolean allowTokenHeader = this.sessionManager.checkToken(tokenHeader);
            if (securitySubject != null || allowToken || allowKey || allowTokenHeader) {
                req.setAttribute("uuid", (Object)UUID.randomUUID().toString().replace("-", ""));
                req.setAttribute("enableRTL", (Object)enableRTL);
                filterChain.doFilter(req, response);
            } else {
                HttpServletResponse res = (HttpServletResponse)response;
                String xReq = request.getHeader("x-requested-with");
                if (!StringUtils.isEmpty((Object)xReq) && "XMLHttpRequest".equalsIgnoreCase(xReq)) {
                    res.sendError(HttpStatus.CREATED.value(), "Not logged in");
                } else if (SecurityFilter.isAccessTokenInvalid(request, allowTokenHeader, allowToken, allowKey)) {
                    res.sendError(HttpStatus.UNAUTHORIZED.value());
                } else {
                    res.sendRedirect("/bioLogin.do");
                }
            }
        }
    }

    private static boolean isAccessTokenInvalid(HttpServletRequest request, boolean allowTokenHeader, boolean allowToken, boolean allowKey) {
        return request.getParameterMap().containsKey("access_token") && !allowToken || SecurityFilter.getHeaderKeys(request).contains("Access-Token") && !allowTokenHeader || (SecurityFilter.getHeaderKeys(request).contains("APP-ID") || SecurityFilter.getHeaderKeys(request).contains("app_id")) && !allowKey;
    }

    private static Set<String> getHeaderKeys(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        HashSet<String> names = new HashSet<String>();
        while (headerNames.hasMoreElements()) {
            names.add((String)headerNames.nextElement());
        }
        return names;
    }

    public static boolean isAuth(String uri) {
        for (String key : filterChainDefinitionMap.keySet()) {
            boolean isMatch = Pattern.matches(key, uri);
            if (!isMatch) continue;
            return "anno".equals(filterChainDefinitionMap.get(key));
        }
        return false;
    }

    public void init(FilterConfig arg0) throws ServletException {
        filterChainDefinitionMap.put("^/", "anno");
        filterChainDefinitionMap.put("^/bioLogin.do", "anno");
        filterChainDefinitionMap.put("^/login.do", "anno");
        filterChainDefinitionMap.put("^/getI18n.do", "anno");
        filterChainDefinitionMap.put("^/complieJSFile.do", "anno");
        filterChainDefinitionMap.put("^/complieCSSFile.do", "anno");
        filterChainDefinitionMap.put("^/getSysParams.do", "anno");
        filterChainDefinitionMap.put("^/public/.*", "anno");
        filterChainDefinitionMap.put("^/ui/.*", "anno");
        filterChainDefinitionMap.put("^/css/.*", "anno");
        filterChainDefinitionMap.put("^/middleware/.*", "anno");
        filterChainDefinitionMap.put("^/images/.*", "anno");
        filterChainDefinitionMap.put("^/favicon.ico", "anno");
        filterChainDefinitionMap.put("^/js/.*", "anno");
        filterChainDefinitionMap.put("^/login/.*", "anno");
        filterChainDefinitionMap.put("^/baseLicense.do*.*", "anno");
        filterChainDefinitionMap.put("^/websocket*.*", "anno");
        filterChainDefinitionMap.put("^/portal*.*", "anno");
        filterChainDefinitionMap.put("^/token*.*", "anno");
        filterChainDefinitionMap.put("^/getAuthResult*.*", "anno");
        filterChainDefinitionMap.put("^/router/rest*.*", "anno");
        if (this.uploadAccess) {
            filterChainDefinitionMap.put("^/upload*.*", "anno");
        }
        if (this.anonUrl != null && !this.anonUrl.isEmpty()) {
            String[] anonArray;
            for (String au : anonArray = this.anonUrl.split(",")) {
                filterChainDefinitionMap.put("^/" + au, "anno");
            }
        }
    }
}

