/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.init;

import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.service.BaseUpgradeVerHandlerService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1400)
public class SystemUpgradeInit
implements CommandLineRunner {
    @Autowired
    private BaseUpgradeVerHandlerService baseUpgradeVerHandlerService;
    @Autowired
    private BaseSysParamService baseSysParamService;

    public void run(String ... args) throws Exception {
        this.upgrade();
    }

    void upgrade() {
        String curVersion = VersionUtil.getReleaseGitTags((String)"system");
        if (!"pro".equals(System.getProperty("spring.profiles.active"))) {
            curVersion = "v2.5.0";
        }
        if (StringUtils.isNotBlank((CharSequence)curVersion)) {
            BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName("SystemUpgradeVersion");
            String curDbVersion = baseSysParamItem.getParamValue();
            this.baseUpgradeVerHandlerService.upgrade(curDbVersion, "system");
            if (!curVersion.equals(curDbVersion)) {
                if (StringUtils.isBlank((CharSequence)baseSysParamItem.getId())) {
                    baseSysParamItem = new BaseSysParamItem("SystemUpgradeVersion", curVersion, "System Upgrade Version", Boolean.valueOf(true));
                } else {
                    baseSysParamItem.setParamValue(curVersion);
                }
                this.baseSysParamService.saveItem(baseSysParamItem);
            }
        }
    }
}

