/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.init;

import com.zkteco.zkbiosecurity.auth.provider.AuthInitDataProvider;
import com.zkteco.zkbiosecurity.auth.vo.AuthRoleItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=999999)
public class SystemRolePermissionInit
implements CommandLineRunner {
    @Autowired
    private AuthInitDataProvider authInitDataProvider;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Value(value="${system.isCloud:false}")
    private Boolean isCloud;
    @Value(value="${system.productCode:ZKBioSecurity}")
    private String productCode;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("SystemRolePermissionInit");
        if (!alreadyInit) {
            this.initAuthRole();
            this.baseSysParamService.setAlreadyInitModule("SystemRolePermissionInit");
        }
    }

    private void initAuthRole() {
        if (!this.isCloud.booleanValue()) {
            this.authInitDataProvider.initRoleData(new AuthRoleItem(I18nUtil.i18nCode((String)"auth_role_initAdminRoleName", (Object[])new Object[0]), "administrator", "administrator"));
            this.authInitDataProvider.initRoleData(new AuthRoleItem(I18nUtil.i18nCode((String)"auth_role_entryClerk", (Object[])new Object[0]), "entry", "entry"));
            this.authInitDataProvider.initRoleData(new AuthRoleItem(I18nUtil.i18nCode((String)"auth_role_monitorClerk", (Object[])new Object[0]), "monitor", "monitor"));
            this.authInitDataProvider.initRoleData(new AuthRoleItem(I18nUtil.i18nCode((String)"pers_person_employee", (Object[])new Object[0]), "employee", "employee"));
        }
    }
}

