/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.utils;

import com.zkteco.zkbiosecurity.core.utils.I18nUtil;

public class AccEnumUtil {

    public static enum ReaderState {
        IN(I18nUtil.i18nCode((String)"common_in", (Object[])new Object[0]), 0),
        OUT(I18nUtil.i18nCode((String)"common_out", (Object[])new Object[0]), 1),
        NO(I18nUtil.i18nCode((String)"common_none", (Object[])new Object[0]), 2);

        private String value;
        private int index;

        private ReaderState(String value, int index) {
            this.value = value;
            this.index = index;
        }

        public static String getValue(int index) {
            for (ReaderState c : ReaderState.values()) {
                if (c.getIndex() != index) continue;
                return c.value;
            }
            return null;
        }

        public String getValue() {
            return this.value;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum EventLevelColor {
        LEVEL0("green", 0),
        LEVEL1("#E57A14", 1),
        LEVEL2("red", 2);

        private String value;
        private int index;

        private EventLevelColor(String value, int index) {
            this.value = value;
            this.index = index;
        }

        public static String getValue(int index) {
            for (EventLevelColor c : EventLevelColor.values()) {
                if (c.getIndex() != index) continue;
                return c.value;
            }
            return null;
        }

        public String getValue() {
            return this.value;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum AuxOutImage {
        OFFLINE(new String[]{"off"}, 0),
        ONLINE(new String[]{"on"}, 1),
        DISABLE(new String[]{"disable"}, 2);

        private String[] values;
        private int index;

        private AuxOutImage(String[] values, int index) {
            this.values = values;
            this.index = index;
        }

        public static String getValue(int index) {
            return AuxOutImage.getValue(index, 0);
        }

        public static String getValue(int index, int valueIndex) {
            for (AuxOutImage c : AuxOutImage.values()) {
                if (c.getIndex() != index) continue;
                return c.values[valueIndex];
            }
            return null;
        }

        public int getIndex() {
            return this.index;
        }

        public String[] getValues() {
            return this.values;
        }
    }

    public static enum AuxInImage {
        OFFLINE(new String[]{"off"}, 0),
        ONLINE(new String[]{"on"}, 1),
        DISABLE(new String[]{"disable"}, 2);

        private String[] values;
        private int index;

        private AuxInImage(String[] values, int index) {
            this.values = values;
            this.index = index;
        }

        public static String getValue(int index) {
            return AuxInImage.getValue(index, 0);
        }

        public static String getValue(int index, int valueIndex) {
            for (AuxInImage c : AuxInImage.values()) {
                if (c.getIndex() != index) continue;
                return c.values[valueIndex];
            }
            return null;
        }

        public int getIndex() {
            return this.index;
        }

        public String[] getValues() {
            return this.values;
        }
    }

    public static enum DoorImage {
        OFFLINE(new String[][][][]{{{{"offline", "offline_to_device"}}}}, 0),
        ONLINE(new String[][][][]{{{{"nosensor_old", "closed_old", "opened_old"}, {"nosensor_old", "closed_old", "opened_old"}}, {{"alarm_nosensor_old", "alarm_closed_old", "alarm_opened_old"}, {"alarm_nosensor_old", "alarm_closed_old", "alarm_opened_old"}}, {{"open_timeout_old", "alarm_timeout_closed_old", "open_timeout_old"}, {"open_timeout_old", "open_timeout_old", "open_timeout_old"}}}, {{{"nosensor", "closed", "opened"}, {"nosensor_unlocked", "closed_unlocked", "opened_unlocked"}}, {{"alarm_nosensor", "alarm_closed", "alarm_opened"}, {"alarm_nosensor_unlocked", "alarm_closed_unlocked", "alarm_opened_unlocked"}}, {{"alarm_nosensor", "alarm_timeout_closed", "alarm_timeout_opened"}, {"alarm_nosensor_unlocked", "alarm_timeout_closed_unlocked", "alarm_timeout_opened_unlocked"}}, {{"alarm_nosensor_cutout", "alarm_closed_cutout", "alarm_opened_cutout"}, {"alarm_nosensor_cutout", "alarm_closed_cutout", "alarm_opened_cutout"}}, {{"alarm_nosensor_poweroff", "alarm_closed_poweroff", "alarm_opened_poweroff"}, {"alarm_nosensor_poweroff", "alarm_closed_poweroff", "alarm_opened_poweroff"}}}}, 1),
        DISABLE(new String[][][][]{{{{"disabled", "disabled"}}}}, 2),
        LOCK(new String[][][][]{{{{"alwayslocked"}}}}, 3);

        private String[][][][] values;
        private int index;

        private DoorImage(String[][][][] values, int index) {
            this.values = values;
            this.index = index;
        }

        private static int getAlarmState(int alarmLevel, int alarmIndex) {
            if (alarmLevel != 0) {
                if ((alarmIndex & 0x80) == 128) {
                    return 1;
                }
                if ((alarmIndex & 0x40) == 64) {
                    return 4;
                }
                if ((alarmIndex & 0x20) == 32) {
                    return 3;
                }
                if ((alarmIndex & 0x10) == 16) {
                    return 2;
                }
                if ((alarmIndex & 0xF) != 0) {
                    return 1;
                }
                if ((alarmIndex >> 8 & 0x1F) != 0) {
                    return 1;
                }
            } else {
                if ((alarmIndex & 0xF) != 0) {
                    return 1;
                }
                if ((alarmIndex & 0x10) == 16) {
                    return 2;
                }
                if ((alarmIndex & 0x20) == 32) {
                    return 3;
                }
                if ((alarmIndex & 0x40) == 64) {
                    return 4;
                }
            }
            return 0;
        }

        public static String getValue(int index, int devOnline, int alarmLevel, int alarmIndex, int relayIndex, int sensorIndex) {
            if (devOnline == 1 && index == 3) {
                return DoorImage.LOCK.values[0][0][0][0];
            }
            for (DoorImage c : DoorImage.values()) {
                if (c.getIndex() != devOnline) continue;
                if (devOnline == 0 || devOnline == 2) {
                    return c.values[0][0][0][0];
                }
                if (devOnline == 1 && index == 0) {
                    return DoorImage.OFFLINE.values[0][0][0][1];
                }
                alarmIndex = DoorImage.getAlarmState(alarmLevel, alarmIndex);
                return c.values[alarmLevel][alarmIndex][relayIndex][sensorIndex];
            }
            return null;
        }

        public int getIndex() {
            return this.index;
        }

        public String[][][][] getValues() {
            return this.values;
        }
    }

    public static enum Alarm {
        OFFLINE(new String[][]{{"common_none"}, {"common_none"}}, 0),
        ONLINE(new String[][]{{"common_none", "acc_rtMonitor_alarm", "acc_rtMonitor_openTimeout"}, {"common_none", "acc_rtMonitor_openForce", "acc_rtMonitor_tamper", "acc_rtMonitor_duressPwdOpen", "acc_rtMonitor_duressFingerOpen", "acc_rtMonitor_duressOpen", "acc_rtMonitor_openTimeout", "acc_newEventNo_58", "acc_newEventNo_54", "acc_newEventNo_55", "acc_newEventNo_56", "acc_newEventNo_57", "acc_newEventNo_106", "acc_newEventNo_107", "acc_newEventNo_109"}}, 1),
        DISABLE(new String[][]{{"acc_rtMonitor_unknown"}, {"acc_rtMonitor_unknown"}}, 2);

        private String[][] values;
        private int index;

        private Alarm(String[][] values, int index) {
            this.values = values;
            this.index = index;
        }

        public static int getAlarmType(int alarmLevel, int alarm) {
            if (alarmLevel != 0) {
                if ((alarm & 8) == 8 && (alarm & 4) == 4) {
                    return 5;
                }
                if ((alarm & 8) == 8) {
                    return 4;
                }
                if ((alarm & 4) == 4) {
                    return 3;
                }
                if ((alarm & 2) == 2) {
                    return 2;
                }
                if ((alarm & 1) == 1) {
                    return 1;
                }
                if ((alarm & 0x10) == 16) {
                    return 6;
                }
                if ((alarm & 0x100) == 256) {
                    return 7;
                }
                if ((alarm & 0x200) == 512) {
                    return 8;
                }
                if ((alarm & 0x400) == 1024) {
                    return 9;
                }
                if ((alarm & 0x800) == 2048) {
                    return 10;
                }
                if ((alarm & 0x1000) == 4096) {
                    return 11;
                }
                if ((alarm & 0x20) == 32) {
                    return 12;
                }
                if ((alarm & 0x40) == 64) {
                    return 13;
                }
                if ((alarm & 0x80) == 128) {
                    return 14;
                }
                return 0;
            }
            if (alarm > 0 && (alarm & 0x10) != 16) {
                return 1;
            }
            if ((alarm & 0x10) == 16) {
                return 2;
            }
            return alarm;
        }

        public static String getValue(int index, int alarmLevel, int alarmIndex) {
            for (Alarm c : Alarm.values()) {
                if (c.getIndex() != index) continue;
                if (index == 0 || index == 2) {
                    return c.values[0][0];
                }
                alarmIndex = Alarm.getAlarmType(alarmLevel, alarmIndex);
                return c.values[alarmLevel][alarmIndex];
            }
            return null;
        }

        public int getIndex() {
            return this.index;
        }

        public String[][] getValues() {
            return this.values;
        }
    }

    public static enum Relay {
        OFFLINE(new String[]{"acc_rtMonitor_unknown"}, 0),
        ONLINE(new String[]{"common_close", "common_open"}, 1),
        DISABLE(new String[]{"acc_rtMonitor_unknown"}, 2);

        private String[] values;
        private int index;

        private Relay(String[] values, int index) {
            this.values = values;
            this.index = index;
        }

        public static String getValue(int index, int valueIndex) {
            for (Relay c : Relay.values()) {
                if (c.getIndex() != index) continue;
                return c.values.length == 1 ? c.values[0] : c.values[valueIndex];
            }
            return null;
        }

        public int getIndex() {
            return this.index;
        }

        public String[] getValues() {
            return this.values;
        }
    }

    public static enum Sensor {
        OFFLINE(new String[]{"acc_rtMonitor_unknown"}, 0),
        ONLINE(new String[]{"acc_rtMonitor_noSensor", "common_close", "common_open"}, 1),
        DISABLE(new String[]{"acc_rtMonitor_unknown"}, 2);

        private String[] values;
        private int index;

        private Sensor(String[] values, int index) {
            this.values = values;
            this.index = index;
        }

        public static String getValue(int index, int valueIndex) {
            for (Sensor c : Sensor.values()) {
                if (c.getIndex() != index) continue;
                return c.values.length == 1 ? c.values[0] : c.values[valueIndex];
            }
            return null;
        }

        public int getIndex() {
            return this.index;
        }

        public String[] getValues() {
            return this.values;
        }
    }
}

