/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.app.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.acc.app.vo.AccAppDoorItem;
import com.zkteco.zkbiosecurity.acc.app.vo.AccAppLevelItem;
import com.zkteco.zkbiosecurity.acc.service.AccAlarmMonitorService;
import com.zkteco.zkbiosecurity.acc.service.AccAppService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.service.AccDoorService;
import com.zkteco.zkbiosecurity.acc.service.AccLevelService;
import com.zkteco.zkbiosecurity.acc.service.AccRTMonitorService;
import com.zkteco.zkbiosecurity.acc.utils.AccEnumUtil;
import com.zkteco.zkbiosecurity.acc.vo.AccDoorItem;
import com.zkteco.zkbiosecurity.acc.vo.AccLevelItem;
import com.zkteco.zkbiosecurity.base.vo.AppResultMessage;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app/v1"})
public class AccAppController {
    @Autowired
    private AccAppService accAppService;
    @Autowired
    private AccLevelService accLevelService;
    @Autowired
    private AccRTMonitorService accRTMonitorService;
    @Autowired
    private AccDeviceService accDeviceService;
    @Autowired
    private AccDoorService accDoorService;
    @Autowired
    private AccAlarmMonitorService accAlarmMonitorService;

    @RequestMapping(value={"/getAccLevels"}, method={RequestMethod.POST})
    public AppResultMessage getAccLevels() {
        AppResultMessage appResultMessage = AppResultMessage.successMessage();
        ArrayList accAppLevelItems = new ArrayList();
        List accLevelItemList = this.accLevelService.getByCondition(new AccLevelItem());
        if (!accLevelItemList.isEmpty()) {
            accLevelItemList.forEach(levelItem -> {
                AccAppLevelItem accAppLevelItem = new AccAppLevelItem();
                accAppLevelItem.setAccLevelId(levelItem.getId()).setAccLevelName(levelItem.getName()).setSelected(levelItem.getInitFlag() != false ? "true" : "false");
                accAppLevelItems.add(accAppLevelItem);
            });
        }
        appResultMessage.setData(accAppLevelItems);
        return appResultMessage;
    }

    @RequestMapping(value={"/getDoorByDoorName"}, method={RequestMethod.POST})
    public AppResultMessage getDoorByDoorName(@RequestBody JSONObject data) {
        String token = data.getString("token");
        String doorName = data.getString("doorName");
        int pageNo = data.getIntValue("pageNo");
        int pageSize = data.getIntValue("pageSize");
        AppResultMessage appResultMessage = this.accAppService.getDoorByDoorName(token, doorName, pageNo, pageSize);
        ArrayList<AccAppDoorItem> accAppDoorItemList = new ArrayList<AccAppDoorItem>();
        JSONObject dataJson = new JSONObject();
        int total = 0;
        if (appResultMessage.getData() != null) {
            JSONObject doorJson = (JSONObject)appResultMessage.getData();
            JSONArray doorArray = doorJson.getJSONArray("rows");
            total = doorJson.getIntValue("totalCount");
            if (doorArray.size() > 0) {
                for (int i = 0; doorArray.size() > i; ++i) {
                    JSONObject door = doorArray.getJSONObject(i);
                    AccAppDoorItem appDoor = new AccAppDoorItem();
                    appDoor.setId(door.getString("id"));
                    appDoor.setDoorName(door.getString("name"));
                    appDoor.setDevName(door.getString("devName"));
                    appDoor.setAreaName(door.containsKey((Object)"areaName") ? door.getString("areaName") : null);
                    if (1 == door.getShortValue("connect")) {
                        if (0 == AccEnumUtil.Alarm.getAlarmType(door.getIntValue("alarmLevel"), door.getIntValue("alarm"))) {
                            appDoor.setDoorAlarmStatus(Integer.valueOf(0));
                        } else {
                            appDoor.setDoorAlarmStatus(Integer.valueOf(1));
                        }
                    } else if (2 == door.getShortValue("connect")) {
                        appDoor.setDoorAlarmStatus(Integer.valueOf(2));
                    } else {
                        appDoor.setDoorAlarmStatus(Integer.valueOf(3));
                    }
                    accAppDoorItemList.add(appDoor);
                }
            }
        }
        dataJson.put("totalCount", (Object)total);
        dataJson.put("rows", accAppDoorItemList);
        appResultMessage.setData((Object)dataJson);
        return appResultMessage;
    }

    @RequestMapping(value={"/operateDoor"}, method={RequestMethod.POST})
    public AppResultMessage operateDoor(@RequestBody JSONObject data) {
        String doorId = data.getString("doorId");
        String type = data.getString("type");
        String interval = data.getString("interval");
        Map dataMap = this.accRTMonitorService.operateDoor(type, interval, doorId);
        return this.dealResultData(dataMap);
    }

    @RequestMapping(value={"/getDoorDataByDoorIdAndFilters"}, method={RequestMethod.POST})
    public AppResultMessage getDoorDataByDoorIdAndFilters(@RequestBody JSONObject data) {
        String doorId = data.getString("doorId");
        String filters = data.getString("filter");
        int pageNo = data.containsKey((Object)"pageNo") ? data.getIntValue("pageNo") : 1;
        int pageSize = data.containsKey((Object)"pageSize") ? data.getIntValue("pageSize") : 20;
        return this.accAppService.getDoorDataByDoorIdAndFilters(doorId, filters, pageNo, pageSize);
    }

    @RequestMapping(value={"/ackAlarm"}, method={RequestMethod.POST})
    public AppResultMessage ackAlarm(@RequestBody JSONObject data) {
        AppResultMessage appResultMessage = new AppResultMessage();
        String ids = data.getString("uniqueKeys");
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.accAlarmMonitorService.checkAlarmMonitor(ids);
            this.accAlarmMonitorService.sendAllAlarmMonitorWS(false);
        }
        return appResultMessage;
    }

    @RequestMapping(value={"/getReportByFilters"}, method={RequestMethod.POST})
    public AppResultMessage getReportByFilters(@RequestBody JSONObject data) {
        int pageNo = data.containsKey((Object)"pageNo") ? data.getIntValue("pageNo") : 1;
        int pageSize = data.containsKey((Object)"pageSize") ? data.getIntValue("pageSize") : 20;
        String filters = data.getString("filters");
        Date startTime = data.containsKey((Object)"startTime") ? data.getDate("startTime") : null;
        Date endTime = data.containsKey((Object)"endTime") ? data.getDate("endTime") : null;
        String doorId = data.getString("doorId");
        return this.accAppService.getReportByFilters(doorId, filters, startTime, endTime, pageNo, pageSize);
    }

    @RequestMapping(value={"/getRTMonitorAlarmData"}, method={RequestMethod.POST})
    public AppResultMessage getRTMonitorAlarmData(@RequestBody JSONObject data) {
        String clientId = data.getString("clientId");
        String userName = data.getString("userName");
        String userPwd = data.getString("userPwd");
        String eventNos = data.getString("eventNos");
        JSONArray retJsonArr = this.accAppService.getAlarmEventData(eventNos);
        JSONObject retJson = new JSONObject();
        retJson.put("ret", (Object)"OK");
        retJson.put("data", (Object)retJsonArr);
        return new AppResultMessage((Object)retJson.toJSONString());
    }

    @RequestMapping(value={"/getAllDoor"}, method={RequestMethod.POST})
    public AppResultMessage getAllDoor() {
        AppResultMessage appResultMessage = AppResultMessage.successMessage();
        List accDoorItemList = this.accDoorService.getByCondition(new AccDoorItem());
        ArrayList accAppDoorItemList = new ArrayList();
        if (!accDoorItemList.isEmpty()) {
            accDoorItemList.forEach(accDoorItem -> {
                AccAppDoorItem accAppDoorItem = new AccAppDoorItem();
                accAppDoorItem.setId(accDoorItem.getId());
                accAppDoorItem.setDoorName(accDoorItem.getName());
                accAppDoorItemList.add(accAppDoorItem);
            });
        }
        appResultMessage.setData(accAppDoorItemList);
        return appResultMessage;
    }

    private AppResultMessage dealResultData(Map<String, String> dataMap) {
        String cmdIdData = dataMap.get("cmdId");
        if ("true".equals(dataMap.get("notExistDev"))) {
            return AppResultMessage.failMessage((String)I18nUtil.i18nCode((String)"common_prompt_exception_datanoexists", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)dataMap.get("offline"))) {
            return AppResultMessage.failMessage((String)I18nUtil.i18nCode((String)"acc_api_devOffline", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)dataMap.get("notSupport"))) {
            return AppResultMessage.failMessage((String)I18nUtil.i18nCode((String)"acc_dev_devNotSupportFunction", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)dataMap.get("faile"))) {
            return AppResultMessage.failMessage((String)I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)cmdIdData)) {
            for (String cmdData : cmdIdData.split(",")) {
                String cmdId = cmdData.split("=", 2)[0];
                Map resultMap = this.accDeviceService.getCmdResultById(Long.valueOf(cmdId), 20);
                if (!Objects.isNull(resultMap) && !Objects.isNull(Integer.parseInt((String)resultMap.get("result"))) && Integer.parseInt((String)resultMap.get("result")) >= 0) continue;
                return AppResultMessage.failMessage();
            }
        }
        return AppResultMessage.successMessage();
    }
}

