/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.sdkClient;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.park.sdkClient.ParkSDKTasks;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryValueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ParkSDKAbnormalCommTask
implements ParkSDKTasks {
    private Logger logger = LoggerFactory.getLogger(ParkSDKAbnormalCommTask.class);
    @Autowired
    private BaseDictionaryValueService baseDictionaryValueService;

    @Override
    @Async(value="parkAsyncTaskExecutor")
    public void doTask(JSONObject json) {
        String ret = json.getString("Ret");
        String opType = json.getString("OpType");
        String errorMsg = (String)this.baseDictionaryValueService.getDictionaryValuesMap("parkDeviceErrorCode").get(ret + "");
        this.logger.error("ZKBiosecurity SDK Service Abnormal communication = " + errorMsg + ",  OpType = " + opType);
    }

    @Override
    public boolean match(JSONObject json) {
        return json.getString("MsgId").length() <= 3;
    }

    @Override
    public long order() {
        return Long.valueOf("5");
    }
}

