/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.sdkClient;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.utils.Base64Util;
import com.zkteco.zkbiosecurity.park.sdkClient.ParkSDKTasks;
import com.zkteco.zkbiosecurity.park.service.ParkCacheService;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceService;
import com.zkteco.zkbiosecurity.park.utils.ParkWebCommonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ParkPlateInfoTask
implements ParkSDKTasks {
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkCacheService parkCacheService;

    @Override
    @Async(value="parkAsyncTaskExecutor")
    public void doTask(JSONObject json) {
        JSONObject dataObj = JSONObject.parseObject((String)Base64Util.getFromBase64((String)json.getString("Data")));
        if (ParkWebCommonUtil.isNotNull(dataObj.getString("License"))) {
            String fullDire = ParkWebCommonUtil.getSystemFilePath();
            String picFileName = dataObj.getString("PicFileName");
            String handle = dataObj.getString("Handle");
            String devIp = this.parkCacheService.getStr("park:dev_handle_" + handle);
            if (ParkWebCommonUtil.isNotNull(devIp)) {
                this.parkDeviceService.routeBusiness(dataObj.getString("License"), devIp, picFileName.substring(fullDire.length()), null);
            }
        }
    }

    @Override
    public boolean match(JSONObject json) {
        return "OnPlateInfo".equalsIgnoreCase(json.getString("OpType"));
    }

    @Override
    public long order() {
        return Long.valueOf("10");
    }
}

