/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="POSID_TRANSACTION t")
@Where(after="AND t.TYPE_NAME != 9")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDTransactionSumItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @GridColumn(show=false)
    private String id;
    @Column(name="t.MONEY")
    @GridColumn(label="posid_cus_money", format="0=0.0")
    private Integer money;
    @Column(name="t.DISCOUNT_MONEY")
    @GridColumn(label="posid_consume_discount_money", format="0=0.0")
    private Integer discountMoney;
    @Column(name="t.BALANCE")
    @GridColumn(label="posid_account_balance", width="100", columnType="custom", convert="convertFen2Yuan")
    private Integer balance;
    @Column(name="t.MONEY_WALLET")
    @GridColumn(label="posid_account_money_wallet", show=true, columnType="custom", convert="convertFen2Yuan")
    private Integer moneyWallet;
    @Column(name="t.ALLOWANCE_WALLET")
    @GridColumn(label="posid_account_allowance_wallet", show=true, columnType="custom", convert="convertFen2Yuan")
    private Integer allowanceWallet;
    @Column(name="t.ACCOUNT_NO")
    @GridColumn(label="posid_card_accountNum", width="90")
    private String accountNo;
    @Column(name="t.TYPE_NAME")
    @GridColumn(label="posid_card_typeName", width="80", format="6=posid_common_consumption,8=posid_cus_supply,9=posid_consumerList_correction,10=posid_consumerList_theTime,11=posid_consumerList_accounting")
    private Integer typeName;
    @Condition(value="t.PERSON_PIN", equalTag="like")
    private String personPin;
    @Condition(value="t.PERSON_NAME", equalTag="like")
    private String personName;
    @Condition(value="t.DEPT_NAME", equalTag="like")
    private String deptName;
    @Condition(value="t.CARD", equalTag="like")
    private String card;
    @Condition(value="t.SYS_CARD_NO", equalTag="=")
    private Integer sysCardNo;
    @Condition(value="t.POS_MODEL", equalTag="=")
    private Integer posModel;
    @Condition(value="t.HALLING_ID", equalTag="=")
    private String hallingId;
    @Condition(value="t.MEAL_ID", equalTag="=")
    private String mealId;
    @Condition(value="t.MEAL_NAME", equalTag="like")
    private String mealName;
    @Condition(value="t.DEV_SN", equalTag="like")
    private String devSn;
    @Condition(value="t.CREATER_CODE", equalTag="like")
    private String createrName;
    @Condition(value="t.POS_TIME", equalTag=">=", toDate=true)
    private String startDatetimeBegin;
    @Condition(value="t.POS_TIME", equalTag="<=", toDate=true)
    private String startDatetimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(t.PERSON_NAME LIKE ''%{0}%'' OR t.PERSON_LAST_NAME LIKE ''%{0}%'')")
    private String likeName;
    @Condition(value="t.PERSON_PIN", equalTag="=")
    private String eqlPersonPin;

    public PosIDTransactionSumItem() {
    }

    public PosIDTransactionSumItem(Boolean equals) {
        super(equals);
    }

    public PosIDTransactionSumItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PosIDTransactionSumItem(String id, String personPin, String personName, String deptName, String hallingId, String card, Integer sysCardNo, String devSn, Integer posModel, String createrName) {
        this.id = id;
        this.personPin = personPin;
        this.personName = personName;
        this.deptName = deptName;
        this.hallingId = hallingId;
        this.card = card;
        this.sysCardNo = sysCardNo;
        this.devSn = devSn;
        this.posModel = posModel;
        this.createrName = createrName;
    }

    public String getId() {
        return this.id;
    }

    public Integer getMoney() {
        return this.money;
    }

    public Integer getDiscountMoney() {
        return this.discountMoney;
    }

    public Integer getBalance() {
        return this.balance;
    }

    public Integer getMoneyWallet() {
        return this.moneyWallet;
    }

    public Integer getAllowanceWallet() {
        return this.allowanceWallet;
    }

    public String getAccountNo() {
        return this.accountNo;
    }

    public Integer getTypeName() {
        return this.typeName;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getCard() {
        return this.card;
    }

    public Integer getSysCardNo() {
        return this.sysCardNo;
    }

    public Integer getPosModel() {
        return this.posModel;
    }

    public String getHallingId() {
        return this.hallingId;
    }

    public String getMealId() {
        return this.mealId;
    }

    public String getMealName() {
        return this.mealName;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public String getCreaterName() {
        return this.createrName;
    }

    public String getStartDatetimeBegin() {
        return this.startDatetimeBegin;
    }

    public String getStartDatetimeEnd() {
        return this.startDatetimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getEqlPersonPin() {
        return this.eqlPersonPin;
    }

    public PosIDTransactionSumItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDTransactionSumItem setMoney(Integer money) {
        this.money = money;
        return this;
    }

    public PosIDTransactionSumItem setDiscountMoney(Integer discountMoney) {
        this.discountMoney = discountMoney;
        return this;
    }

    public PosIDTransactionSumItem setBalance(Integer balance) {
        this.balance = balance;
        return this;
    }

    public PosIDTransactionSumItem setMoneyWallet(Integer moneyWallet) {
        this.moneyWallet = moneyWallet;
        return this;
    }

    public PosIDTransactionSumItem setAllowanceWallet(Integer allowanceWallet) {
        this.allowanceWallet = allowanceWallet;
        return this;
    }

    public PosIDTransactionSumItem setAccountNo(String accountNo) {
        this.accountNo = accountNo;
        return this;
    }

    public PosIDTransactionSumItem setTypeName(Integer typeName) {
        this.typeName = typeName;
        return this;
    }

    public PosIDTransactionSumItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosIDTransactionSumItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosIDTransactionSumItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosIDTransactionSumItem setCard(String card) {
        this.card = card;
        return this;
    }

    public PosIDTransactionSumItem setSysCardNo(Integer sysCardNo) {
        this.sysCardNo = sysCardNo;
        return this;
    }

    public PosIDTransactionSumItem setPosModel(Integer posModel) {
        this.posModel = posModel;
        return this;
    }

    public PosIDTransactionSumItem setHallingId(String hallingId) {
        this.hallingId = hallingId;
        return this;
    }

    public PosIDTransactionSumItem setMealId(String mealId) {
        this.mealId = mealId;
        return this;
    }

    public PosIDTransactionSumItem setMealName(String mealName) {
        this.mealName = mealName;
        return this;
    }

    public PosIDTransactionSumItem setDevSn(String devSn) {
        this.devSn = devSn;
        return this;
    }

    public PosIDTransactionSumItem setCreaterName(String createrName) {
        this.createrName = createrName;
        return this;
    }

    public PosIDTransactionSumItem setStartDatetimeBegin(String startDatetimeBegin) {
        this.startDatetimeBegin = startDatetimeBegin;
        return this;
    }

    public PosIDTransactionSumItem setStartDatetimeEnd(String startDatetimeEnd) {
        this.startDatetimeEnd = startDatetimeEnd;
        return this;
    }

    public PosIDTransactionSumItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDTransactionSumItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PosIDTransactionSumItem setEqlPersonPin(String eqlPersonPin) {
        this.eqlPersonPin = eqlPersonPin;
        return this;
    }

    public String toString() {
        return "PosIDTransactionSumItem(id=" + this.getId() + ", money=" + this.getMoney() + ", discountMoney=" + this.getDiscountMoney() + ", balance=" + this.getBalance() + ", moneyWallet=" + this.getMoneyWallet() + ", allowanceWallet=" + this.getAllowanceWallet() + ", accountNo=" + this.getAccountNo() + ", typeName=" + this.getTypeName() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", deptName=" + this.getDeptName() + ", card=" + this.getCard() + ", sysCardNo=" + this.getSysCardNo() + ", posModel=" + this.getPosModel() + ", hallingId=" + this.getHallingId() + ", mealId=" + this.getMealId() + ", mealName=" + this.getMealName() + ", devSn=" + this.getDevSn() + ", createrName=" + this.getCreaterName() + ", startDatetimeBegin=" + this.getStartDatetimeBegin() + ", startDatetimeEnd=" + this.getStartDatetimeEnd() + ", inDeptId=" + this.getInDeptId() + ", likeName=" + this.getLikeName() + ", eqlPersonPin=" + this.getEqlPersonPin() + ")";
    }
}

