/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.DelegatableDecoder;

public class DoubleByte {
    public static final char[] B2C_UNMAPPABLE = new char[256];

    static {
        Arrays.fill(B2C_UNMAPPABLE, '\ufffd');
    }

    public static class Decoder
    extends CharsetDecoder
    implements DelegatableDecoder {
        final char[][] b2c;
        final char[] b2cSB;
        final int b2Min;
        final int b2Max;

        protected CoderResult crMalformedOrUnderFlow(int n) {
            return CoderResult.UNDERFLOW;
        }

        protected CoderResult crMalformedOrUnmappable(int n) {
            return CoderResult.unmappableForLength(2);
        }

        Decoder(Charset charset, float f, float f2, char[][] cArray, char[] cArray2, int n, int n2) {
            super(charset, f, f2);
            this.b2c = cArray;
            this.b2cSB = cArray2;
            this.b2Min = n;
            this.b2Max = n2;
        }

        Decoder(Charset charset, char[][] cArray, char[] cArray2, int n, int n2) {
            this(charset, 0.5f, 1.0f, cArray, cArray2, n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n;
            byte[] byArray = byteBuffer.array();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            try {
                int n5;
                for (n = byteBuffer.arrayOffset() + byteBuffer.position(); n < n2 && n3 < n4; n += n5) {
                    n5 = 1;
                    int n6 = byArray[n] & 0xFF;
                    char c = this.b2cSB[n6];
                    if (c == '\ufffd') {
                        if (n2 - n < 2) {
                            CoderResult coderResult = this.crMalformedOrUnderFlow(n6);
                            return coderResult;
                        }
                        int n7 = byArray[n + 1] & 0xFF;
                        if (n7 < this.b2Min || n7 > this.b2Max || (c = this.b2c[n6][n7 - this.b2Min]) == '\ufffd') {
                            CoderResult coderResult = this.crMalformedOrUnmappable(n6);
                            return coderResult;
                        }
                        ++n5;
                    }
                    cArray[n3++] = c;
                }
                CoderResult coderResult = n >= n2 ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n3 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            try {
                while (byteBuffer.hasRemaining() && charBuffer.hasRemaining()) {
                    int n2 = byteBuffer.get() & 0xFF;
                    char c = this.b2cSB[n2];
                    int n3 = 1;
                    if (c == '\ufffd') {
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = this.crMalformedOrUnderFlow(n2);
                            return coderResult;
                        }
                        int n4 = byteBuffer.get() & 0xFF;
                        if (n4 < this.b2Min || n4 > this.b2Max || (c = this.b2c[n2][n4 - this.b2Min]) == '\ufffd') {
                            CoderResult coderResult = this.crMalformedOrUnmappable(n2);
                            return coderResult;
                        }
                        ++n3;
                    }
                    charBuffer.put(c);
                    n += n3;
                }
                CoderResult coderResult = byteBuffer.hasRemaining() ? CoderResult.OVERFLOW : CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        @Override
        public CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        @Override
        public void implReset() {
            super.implReset();
        }

        @Override
        public CoderResult implFlush(CharBuffer charBuffer) {
            return super.implFlush(charBuffer);
        }

        public char decodeSingle(int n) {
            return this.b2cSB[n];
        }

        public char decodeDouble(int n, int n2) {
            if (n2 < this.b2Min || n2 > this.b2Max) {
                return '\ufffd';
            }
            return this.b2c[n][n2 - this.b2Min];
        }
    }

    public static class Encoder
    extends CharsetEncoder {
        final int MAX_SINGLEBYTE = 255;
        private final char[] c2b;
        private final char[] c2bIndex;
        Surrogate.Parser sgp;

        protected Encoder(Charset charset, char[] cArray, char[] cArray2) {
            super(charset, 2.0f, 2.0f);
            this.c2b = cArray;
            this.c2bIndex = cArray2;
        }

        Encoder(Charset charset, float f, float f2, byte[] byArray, char[] cArray, char[] cArray2) {
            super(charset, f, f2, byArray);
            this.c2b = cArray;
            this.c2bIndex = cArray2;
        }

        @Override
        public boolean canEncode(char c) {
            return this.encodeChar(c) != 65533;
        }

        Surrogate.Parser sgp() {
            if (this.sgp == null) {
                this.sgp = new Surrogate.Parser();
            }
            return this.sgp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n;
            char[] cArray = charBuffer.array();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            try {
                for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
                    char c = cArray[n];
                    int n5 = this.encodeChar(c);
                    if (n5 == 65533) {
                        if (Character.isSurrogate(c)) {
                            if (this.sgp().parse(c, cArray, n, n2) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            CoderResult coderResult = this.sgp.unmappableResult();
                            return coderResult;
                        }
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (n5 > 255) {
                        if (n4 - n3 < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n3++] = (byte)(n5 >> 8);
                        byArray[n3++] = (byte)n5;
                        continue;
                    }
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byArray[n3++] = (byte)n5;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    char c = charBuffer.get();
                    int n2 = this.encodeChar(c);
                    if (n2 == 65533) {
                        if (Character.isSurrogate(c)) {
                            if (this.sgp().parse(c, charBuffer) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            CoderResult coderResult = this.sgp.unmappableResult();
                            return coderResult;
                        }
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (n2 > 255) {
                        if (byteBuffer.remaining() < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)(n2 >> 8));
                        byteBuffer.put((byte)n2);
                    } else {
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)n2);
                    }
                    ++n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }

        public int encodeChar(char c) {
            return this.c2b[this.c2bIndex[c >> 8] + (c & 0xFF)];
        }

        static void initC2B(String[] stringArray, String string, String string2, String string3, int n, int n2, char[] cArray, char[] cArray2) {
            int n3;
            int n4;
            char c;
            int n5;
            Arrays.fill(cArray, '\ufffd');
            int n6 = 256;
            char[][] cArrayArray = new char[stringArray.length][];
            char[] cArray3 = null;
            if (string != null) {
                cArray3 = string.toCharArray();
            }
            for (n5 = 0; n5 < stringArray.length; ++n5) {
                if (stringArray[n5] == null) continue;
                cArrayArray[n5] = stringArray[n5].toCharArray();
            }
            if (string2 != null) {
                n5 = 0;
                while (n5 < string2.length()) {
                    c = string2.charAt(n5++);
                    n4 = string2.charAt(n5++);
                    if (c < '\u0100' && cArray3 != null) {
                        if (cArray3[c] != n4) continue;
                        cArray3[c] = 65533;
                        continue;
                    }
                    if (cArrayArray[c >> 8][(c & 0xFF) - n] != n4) continue;
                    cArrayArray[c >> 8][(c & 0xFF) - n] = 65533;
                }
            }
            if (cArray3 != null) {
                for (n5 = 0; n5 < cArray3.length; ++n5) {
                    c = cArray3[n5];
                    if (c == '\ufffd') continue;
                    n4 = cArray2[c >> 8];
                    if (n4 == 0) {
                        n4 = n6;
                        n6 += 256;
                        cArray2[c >> 8] = (char)n4;
                    }
                    cArray[n4 + (c & 0xFF)] = (char)n5;
                }
            }
            for (n5 = 0; n5 < stringArray.length; ++n5) {
                char[] cArray4 = cArrayArray[n5];
                if (cArray4 == null) continue;
                for (n4 = n; n4 <= n2; ++n4) {
                    n3 = cArray4[n4 - n];
                    if (n3 == 65533) continue;
                    int n7 = cArray2[n3 >> 8];
                    if (n7 == 0) {
                        n7 = n6;
                        n6 += 256;
                        cArray2[n3 >> 8] = (char)n7;
                    }
                    cArray[n7 + (n3 & 0xFF)] = (char)(n5 << 8 | n4);
                }
            }
            if (string3 != null) {
                for (n5 = 0; n5 < string3.length(); n5 += 2) {
                    char c2 = string3.charAt(n5);
                    n4 = string3.charAt(n5 + 1);
                    n3 = n4 >> 8;
                    if (cArray2[n3] == '\u0000') {
                        cArray2[n3] = (char)n6;
                        n6 += 256;
                    }
                    n3 = cArray2[n3] + (n4 & 0xFF);
                    cArray[n3] = c2;
                }
            }
        }
    }
}

