/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.remote.util.ClassLogger;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class NotificationBroadcasterSupport
implements NotificationEmitter {
    private List<ListenerInfo> listenerList = new CopyOnWriteArrayList<ListenerInfo>();
    private final Executor executor;
    private final MBeanNotificationInfo[] notifInfo;
    private static final Executor defaultExecutor = new Executor(){

        @Override
        public void execute(Runnable runnable) {
            runnable.run();
        }
    };
    private static final MBeanNotificationInfo[] NO_NOTIFICATION_INFO = new MBeanNotificationInfo[0];
    private static final ClassLogger logger = new ClassLogger("javax.management", "NotificationBroadcasterSupport");

    public NotificationBroadcasterSupport() {
        this((Executor)null, (MBeanNotificationInfo[])null);
    }

    public NotificationBroadcasterSupport(Executor executor) {
        this(executor, (MBeanNotificationInfo[])null);
    }

    public NotificationBroadcasterSupport(MBeanNotificationInfo ... mBeanNotificationInfoArray) {
        this((Executor)null, mBeanNotificationInfoArray);
    }

    public NotificationBroadcasterSupport(Executor executor, MBeanNotificationInfo ... mBeanNotificationInfoArray) {
        this.executor = executor != null ? executor : defaultExecutor;
        this.notifInfo = mBeanNotificationInfoArray == null ? NO_NOTIFICATION_INFO : (MBeanNotificationInfo[])mBeanNotificationInfoArray.clone();
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (notificationListener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        this.listenerList.add(new ListenerInfo(notificationListener, notificationFilter, object));
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        WildcardListenerInfo wildcardListenerInfo = new WildcardListenerInfo(notificationListener);
        boolean bl = this.listenerList.removeAll(Collections.singleton(wildcardListenerInfo));
        if (!bl) {
            throw new ListenerNotFoundException("Listener not registered");
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        ListenerInfo listenerInfo = new ListenerInfo(notificationListener, notificationFilter, object);
        boolean bl = this.listenerList.remove(listenerInfo);
        if (!bl) {
            throw new ListenerNotFoundException("Listener not registered (with this filter and handback)");
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.notifInfo.length == 0) {
            return this.notifInfo;
        }
        return (MBeanNotificationInfo[])this.notifInfo.clone();
    }

    public void sendNotification(Notification notification) {
        if (notification == null) {
            return;
        }
        for (ListenerInfo listenerInfo : this.listenerList) {
            boolean bl;
            try {
                bl = listenerInfo.filter == null || listenerInfo.filter.isNotificationEnabled(notification);
            }
            catch (Exception exception) {
                if (!logger.debugOn()) continue;
                logger.debug("sendNotification", exception);
                continue;
            }
            if (!bl) continue;
            this.executor.execute(new SendNotifJob(notification, listenerInfo));
        }
    }

    protected void handleNotification(NotificationListener notificationListener, Notification notification, Object object) {
        notificationListener.handleNotification(notification, object);
    }

    static /* synthetic */ ClassLogger access$000() {
        return logger;
    }

    private static class ListenerInfo {
        NotificationListener listener;
        NotificationFilter filter;
        Object handback;

        ListenerInfo(NotificationListener listener, NotificationFilter filter, Object handback) {
            this.listener = listener;
            this.filter = filter;
            this.handback = handback;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ListenerInfo)) {
                return false;
            }
            ListenerInfo li = (ListenerInfo)o;
            if (li instanceof WildcardListenerInfo) {
                return li.listener == this.listener;
            }
            return li.listener == this.listener && li.filter == this.filter && li.handback == this.handback;
        }

        public int hashCode() {
            return Objects.hashCode(this.listener);
        }
    }

    private class SendNotifJob
    implements Runnable {
        private final Notification notif;
        private final ListenerInfo listenerInfo;

        public SendNotifJob(Notification notif, ListenerInfo listenerInfo) {
            this.notif = notif;
            this.listenerInfo = listenerInfo;
        }

        @Override
        public void run() {
            block2: {
                try {
                    NotificationBroadcasterSupport.this.handleNotification(this.listenerInfo.listener, this.notif, this.listenerInfo.handback);
                }
                catch (Exception e) {
                    if (!logger.debugOn()) break block2;
                    logger.debug("SendNotifJob-run", e);
                }
            }
        }
    }

    private static class WildcardListenerInfo
    extends ListenerInfo {
        WildcardListenerInfo(NotificationListener listener) {
            super(listener, null, null);
        }

        @Override
        public boolean equals(Object o) {
            assert (!(o instanceof WildcardListenerInfo));
            return o.equals(this);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

