/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import sun.invoke.empty.Empty;
import sun.misc.Unsafe;

public abstract class CallSite {
    MethodHandle target;
    private static final MethodHandle GET_TARGET;
    private static final long TARGET_OFFSET;

    CallSite(MethodType methodType) {
        this.target = methodType.invokers().uninitializedCallSite();
    }

    CallSite(MethodHandle methodHandle) {
        methodHandle.type();
        this.target = methodHandle;
    }

    CallSite(MethodType methodType, MethodHandle methodHandle) throws Throwable {
        this(methodType);
        ConstantCallSite constantCallSite = (ConstantCallSite)this;
        MethodHandle methodHandle2 = (MethodHandle)methodHandle.invokeWithArguments(constantCallSite);
        this.checkTargetChange(this.target, methodHandle2);
        this.target = methodHandle2;
    }

    public MethodType type() {
        return this.target.type();
    }

    public abstract MethodHandle getTarget();

    public abstract void setTarget(MethodHandle var1);

    void checkTargetChange(MethodHandle methodHandle, MethodHandle methodHandle2) {
        MethodType methodType = methodHandle.type();
        MethodType methodType2 = methodHandle2.type();
        if (!methodType2.equals((Object)methodType)) {
            throw CallSite.wrongTargetType(methodHandle2, methodType);
        }
    }

    private static WrongMethodTypeException wrongTargetType(MethodHandle methodHandle, MethodType methodType) {
        return new WrongMethodTypeException(String.valueOf(methodHandle) + " should be of type " + methodType);
    }

    public abstract MethodHandle dynamicInvoker();

    MethodHandle makeDynamicInvoker() {
        MethodHandle methodHandle = GET_TARGET.bindReceiver(this);
        MethodHandle methodHandle2 = MethodHandles.exactInvoker(this.type());
        return MethodHandles.foldArguments(methodHandle2, methodHandle);
    }

    static Empty uninitializedCallSite() {
        throw new IllegalStateException("uninitialized call site");
    }

    void setTargetNormal(MethodHandle methodHandle) {
        MethodHandleNatives.setCallSiteTargetNormal(this, methodHandle);
    }

    MethodHandle getTargetVolatile() {
        return (MethodHandle)((Unsafe)((Object)MethodHandleStatics.UNSAFE)).getObjectVolatile(this, TARGET_OFFSET);
    }

    void setTargetVolatile(MethodHandle methodHandle) {
        MethodHandleNatives.setCallSiteTargetVolatile(this, methodHandle);
    }

    static CallSite makeSite(MethodHandle methodHandle, String string, MethodType methodType, Object object, Class<?> clazz) {
        CallSite callSite;
        MethodHandles.Lookup lookup = MethodHandles.Lookup.IMPL_LOOKUP.in(clazz);
        try {
            Object object2;
            object = CallSite.maybeReBox(object);
            if (object == null) {
                object2 = methodHandle.invoke(lookup, string, methodType);
            } else if (!object.getClass().isArray()) {
                object2 = methodHandle.invoke(lookup, string, methodType, object);
            } else {
                Object[] objectArray = (Object[])object;
                CallSite.maybeReBoxElements(objectArray);
                if (3 + objectArray.length > 255) {
                    throw new BootstrapMethodError("too many bootstrap method arguments");
                }
                MethodType methodType2 = methodHandle.type();
                object2 = methodType2.parameterCount() == 4 && methodType2.parameterType(3) == Object[].class ? methodHandle.invoke(lookup, string, methodType, objectArray) : MethodHandles.spreadInvoker(methodType2, 3).invoke(methodHandle, lookup, string, methodType, objectArray);
            }
            if (!(object2 instanceof CallSite)) {
                throw new ClassCastException("bootstrap method failed to produce a CallSite");
            }
            callSite = (CallSite)object2;
            if (!callSite.getTarget().type().equals((Object)methodType)) {
                throw new WrongMethodTypeException("wrong type: " + callSite.getTarget());
            }
        }
        catch (Throwable throwable) {
            BootstrapMethodError bootstrapMethodError = throwable instanceof BootstrapMethodError ? (BootstrapMethodError)throwable : new BootstrapMethodError("call site initialization exception", throwable);
            throw bootstrapMethodError;
        }
        return callSite;
    }

    private static Object maybeReBox(Object object) {
        int n;
        if (object instanceof Integer && (n = ((Integer)object).intValue()) == (byte)n) {
            object = n;
        }
        return object;
    }

    private static void maybeReBoxElements(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = CallSite.maybeReBox(objectArray[i]);
        }
    }

    static {
        MethodHandleImpl.initStatics();
        try {
            GET_TARGET = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(CallSite.class, "getTarget", MethodType.methodType(MethodHandle.class));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw MethodHandleStatics.newInternalError((Throwable)reflectiveOperationException);
        }
        try {
            TARGET_OFFSET = ((Unsafe)((Object)MethodHandleStatics.UNSAFE)).objectFieldOffset(CallSite.class.getDeclaredField("target"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

