/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import sun.nio.fs.Globs;
import sun.nio.fs.Util;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileSystem;
import sun.nio.fs.WindowsFileSystemProvider;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;
import sun.nio.fs.WindowsPathParser;
import sun.nio.fs.WindowsPathType;
import sun.nio.fs.WindowsWatchService;
import sun.security.action.GetPropertyAction;

class WindowsFileSystem
extends FileSystem {
    private final WindowsFileSystemProvider provider;
    private final String defaultDirectory;
    private final String defaultRoot;
    private final boolean supportsLinks;
    private final boolean supportsStreamEnumeration;
    private static final Set<String> supportedFileAttributeViews = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("basic", "dos", "acl", "owner", "user")));
    private static final String GLOB_SYNTAX = "glob";
    private static final String REGEX_SYNTAX = "regex";

    WindowsFileSystem(WindowsFileSystemProvider windowsFileSystemProvider, String string) {
        this.provider = windowsFileSystemProvider;
        WindowsPathParser.Result result = WindowsPathParser.parse(string);
        if (result.type() != WindowsPathType.ABSOLUTE && result.type() != WindowsPathType.UNC) {
            throw new AssertionError((Object)"Default directory is not an absolute path");
        }
        this.defaultDirectory = result.path();
        this.defaultRoot = result.root();
        GetPropertyAction getPropertyAction = new GetPropertyAction("os.version");
        String string2 = AccessController.doPrivileged(getPropertyAction);
        String[] stringArray = Util.split(string2, '.');
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        this.supportsLinks = n >= 6;
        this.supportsStreamEnumeration = n >= 6 || n == 5 && n2 >= 2;
    }

    String defaultDirectory() {
        return this.defaultDirectory;
    }

    String defaultRoot() {
        return this.defaultRoot;
    }

    boolean supportsLinks() {
        return this.supportsLinks;
    }

    boolean supportsStreamEnumeration() {
        return this.supportsStreamEnumeration;
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public String getSeparator() {
        return "\\";
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        int n = 0;
        try {
            n = WindowsNativeDispatcher.GetLogicalDrives();
        }
        catch (WindowsException windowsException) {
            throw new AssertionError((Object)windowsException.getMessage());
        }
        ArrayList<WindowsPath> arrayList = new ArrayList<WindowsPath>();
        SecurityManager securityManager = System.getSecurityManager();
        for (int i = 0; i <= 25; ++i) {
            if ((n & 1 << i) == 0) continue;
            StringBuilder stringBuilder = new StringBuilder(3);
            stringBuilder.append((char)(65 + i));
            stringBuilder.append(":\\");
            String string = stringBuilder.toString();
            if (securityManager != null) {
                try {
                    securityManager.checkRead(string);
                }
                catch (SecurityException securityException) {
                    continue;
                }
            }
            arrayList.add(WindowsPath.createFromNormalizedPath(this, string));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new RuntimePermission("getFileStoreAttributes"));
            }
            catch (SecurityException securityException) {
                return Collections.emptyList();
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return supportedFileAttributeViews;
    }

    @Override
    public final Path getPath(String string, String ... stringArray) {
        String string2;
        if (stringArray.length == 0) {
            string2 = string;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            for (String string3 : stringArray) {
                if (string3.length() <= 0) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(string3);
            }
            string2 = stringBuilder.toString();
        }
        return WindowsPath.parse(this, string2);
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return LookupService.instance;
    }

    @Override
    public PathMatcher getPathMatcher(String string) {
        String string2;
        int n = string.indexOf(58);
        if (n <= 0 || n == string.length()) {
            throw new IllegalArgumentException();
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        if (string3.equals(GLOB_SYNTAX)) {
            string2 = Globs.toWindowsRegexPattern(string4);
        } else if (string3.equals(REGEX_SYNTAX)) {
            string2 = string4;
        } else {
            throw new UnsupportedOperationException("Syntax '" + string3 + "' not recognized");
        }
        Pattern pattern = Pattern.compile(string2, 66);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return new WindowsWatchService(this);
    }
}

