/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.BaseFont;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZKBaseFontUtil {
    public static String TH_FONT_PATH = "/fonts/angsa.ttf";
    public static String EN_FONT_PATH = "/fonts/arial.ttf";
    public static String KO_FONT_PATH = "/fonts/korean.ttf";
    public static Map<String, Font> fonts = new HashMap<String, Font>();

    private static String getFontKey(String s) {
        if (ZKBaseFontUtil.isContainTH(s)) {
            return "th";
        }
        if (ZKBaseFontUtil.isContainChinese(s)) {
            return "cn";
        }
        if (ZKBaseFontUtil.isContainArab(s)) {
            return "en";
        }
        if (ZKBaseFontUtil.isContainKo(s)) {
            return "ko";
        }
        if (ZKBaseFontUtil.isContainJP(s)) {
            return "jp";
        }
        return "en";
    }

    private static boolean isContainKo(String str) {
        Pattern p = Pattern.compile("([\\u1100-\\u11ff\\uac00-\\ud7af\\u3130\u2013\\u318F\\u3200\u2013\\u32FF\\uA960\u2013\\uA97F\\uD7B0\u2013\\uD7FF\\uFF00\u2013\\uFFEF\\s]+)");
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static Font getBodyFont(String s) {
        return fonts.get(ZKBaseFontUtil.getFontKey(s) + "BodyFont");
    }

    public static Font getTitleFont(String s) {
        return fonts.get(ZKBaseFontUtil.getFontKey(s) + "TitleFont");
    }

    public static boolean isContainChinese(String str) {
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static boolean isContainJP(String str) {
        Pattern p = Pattern.compile("[\u0800-\u4e00]");
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static boolean isContainArab(String str) {
        Pattern p = Pattern.compile("[\u060c-\u06fe]");
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static boolean isContainTH(String str) {
        Pattern p = Pattern.compile("[\u0e00-\u0e7f]");
        Matcher m = p.matcher(str);
        return m.find();
    }

    static {
        try {
            BaseFont bfChinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font cnBodyFont = new Font(bfChinese, 10.0f, 0);
            Font cnTitleFont = new Font(bfChinese, 16.0f, 1);
            fonts.put("cnBodyFont", cnBodyFont);
            fonts.put("cnTitleFont", cnTitleFont);
            BaseFont bfJP = BaseFont.createFont((String)"HeiseiKakuGo-W5", (String)"UniJIS-UCS2-H", (boolean)true);
            Font jpBodyFont = new Font(bfJP, 10.0f, 0);
            Font jpTitleFont = new Font(bfJP, 16.0f, 1);
            fonts.put("jpBodyFont", jpBodyFont);
            fonts.put("jpTitleFont", jpTitleFont);
            BaseFont bfth = BaseFont.createFont((String)TH_FONT_PATH, (String)"Identity-H", (boolean)true);
            Font thBodyFont = new Font(bfth, 10.0f, 0);
            Font thTitleFont = new Font(bfth, 16.0f, 1);
            fonts.put("thBodyFont", thBodyFont);
            fonts.put("thTitleFont", thTitleFont);
            BaseFont bfko = BaseFont.createFont((String)KO_FONT_PATH, (String)"Identity-H", (boolean)true);
            Font koBodyFont = new Font(bfko, 10.0f, 0);
            Font koTitleFont = new Font(bfko, 16.0f, 1);
            fonts.put("koBodyFont", koBodyFont);
            fonts.put("koTitleFont", koTitleFont);
            BaseFont bfen = BaseFont.createFont((String)EN_FONT_PATH, (String)"Identity-H", (boolean)true);
            Font enBodyFont = new Font(bfen, 10.0f, 0);
            Font enTitleFont = new Font(bfen, 16.0f, 1);
            fonts.put("enBodyFont", enBodyFont);
            fonts.put("enTitleFont", enTitleFont);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

