/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pos.remote.PosMealRemote;
import com.zkteco.zkbiosecurity.pos.service.PosMealService;
import com.zkteco.zkbiosecurity.pos.vo.PosMealItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosMealController
extends BaseController
implements PosMealRemote {
    @Autowired
    private PosMealService posMealService;

    @RequiresPermissions(value={"pos:meal"})
    public ModelAndView index() {
        return new ModelAndView("pos/meal/posMeal");
    }

    @RequiresPermissions(value={"pos:meal:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posMealService.getItemById(id));
        }
        return new ModelAndView("pos/meal/editPosMeal");
    }

    @RequiresPermissions(value={"pos:meal:edit"})
    @LogRequest(module="pos_module", object="pos_leftMenu_meal", opType="common_op_edit", requestParams={"code"}, opContent="pos_meal_code")
    public ZKResultMsg save(PosMealItem item) {
        ZKResultMsg res = new ZKResultMsg();
        boolean oldAvailable = Boolean.parseBoolean(this.request.getParameter("oldAvailable"));
        this.posMealService.saveItem(item, oldAvailable);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pos:meal:refresh"})
    public DxGrid list(PosMealItem codition) {
        Pager pager = this.posMealService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="pos_module", object="pos_leftMenu_meal", opType="common_op_del", requestParams={"ids"}, opContent="pos_common_id")
    public String validName(String name) {
        PosMealItem item = this.posMealService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public TreeItem tree() {
        PosMealItem posMealItem = new PosMealItem();
        posMealItem.setAvailable(Boolean.valueOf(true));
        List items = this.posMealService.getByCondition(posMealItem);
        ArrayList<TreeItem> tempItems = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = null;
        for (PosMealItem depart : items) {
            item = new TreeItem();
            item.setId(depart.getId());
            item.setText(depart.getName() + " " + depart.getStartTime() + "-" + depart.getEndTime());
            pItem = new TreeItem("0");
            item.setParent(pItem);
            tempItems.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(tempItems);
        return new TreeItem("0", treeItems);
    }

    public ZKResultMsg getMealNameList() {
        return new ZKResultMsg((Object)this.posMealService.getMealNameList());
    }

    public ZKResultMsg checkTimeseg() {
        String id = this.request.getParameter("splitTimeId");
        String startStr = this.request.getParameter("startTime");
        String endStr = this.request.getParameter("endTime");
        boolean available = Boolean.parseBoolean(this.request.getParameter("available"));
        return this.posMealService.checkTimeseg(id, startStr, endStr, available);
    }
}

