/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pos.remote.PosCardKindRemote;
import com.zkteco.zkbiosecurity.pos.service.PosCardKindService;
import com.zkteco.zkbiosecurity.pos.service.PosSystemParamService;
import com.zkteco.zkbiosecurity.pos.vo.PosCardKindItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosCardKindController
extends BaseController
implements PosCardKindRemote {
    @Autowired
    private PosCardKindService posCardKindService;
    @Autowired
    private PosSystemParamService posSystemParamService;

    @RequiresPermissions(value={"pos:cardKind"})
    public ModelAndView index() {
        return new ModelAndView("pos/cardKind/posCardKind");
    }

    @RequiresPermissions(value={"pos:cardKind:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posCardKindService.getItemById(id));
        } else {
            PosCardKindItem item = new PosCardKindItem();
            String highLimit = this.posSystemParamService.getValByName("pos.highLimit");
            item.setMaxMoney(Double.valueOf(highLimit));
            this.request.setAttribute("item", (Object)item);
            this.request.setAttribute("highLimit", (Object)highLimit);
        }
        return new ModelAndView("pos/cardKind/editPosCardKind");
    }

    @RequiresPermissions(value={"pos:cardKind:edit"})
    @LogRequest(module="pos_module", object="pos_leftMenu_icCard", opType="common_op_edit", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(PosCardKindItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.posCardKindService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pos:cardKind:refresh"})
    public DxGrid list(PosCardKindItem codition) {
        Pager pager = this.posCardKindService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"pos:cardKind:del"})
    @LogRequest(module="pos_module", object="pos_leftMenu_icCard", opType="common_op_del", requestParams={"names"}, opContent="common_name")
    public ZKResultMsg delete(String ids) {
        this.posCardKindService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getCardKindList() {
        List items = this.posCardKindService.getCardKindList();
        return new ZKResultMsg((Object)items);
    }

    public String validCode(String code) {
        PosCardKindItem item = this.posCardKindService.getItemByCode(code);
        boolean rs = item == null;
        return rs + "";
    }

    public TreeItem tree() {
        List posCardKindItems = this.posCardKindService.getByCondition(new PosCardKindItem());
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        for (PosCardKindItem posCardKind : posCardKindItems) {
            item = new TreeItem();
            item.setId(posCardKind.getId());
            item.setText(posCardKind.getName());
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public Boolean validMaxMoney(String maxMoney) {
        String highLimit = this.posSystemParamService.getValByName("pos.highLimit");
        return Double.valueOf(maxMoney) <= Double.valueOf(highLimit);
    }
}

