/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.Preconditions;
import java.security.ProviderException;
import java.util.List;
import java.util.function.BiFunction;

final class RangeUtil {
    private static final BiFunction<String, List<Integer>, ArrayIndexOutOfBoundsException> AIOOBE_SUPPLIER = Preconditions.outOfBoundsExceptionFormatter(ArrayIndexOutOfBoundsException::new);

    RangeUtil() {
    }

    public static void blockSizeCheck(int len, int blockSize) {
        if (len % blockSize != 0) {
            throw new ProviderException("Internal error in input buffering");
        }
    }

    public static void nullAndBoundsCheck(byte[] array, int offset, int len) {
        Preconditions.checkFromIndexSize(offset, len, array.length, AIOOBE_SUPPLIER);
    }
}

