/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.guard.license.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class RSAUtil {
    private static final Logger logger = LoggerFactory.getLogger(RSAUtil.class);
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;
    private static Cipher cipher;
    private static RSAPublicKey pubKey;
    private static RSAPrivateKey priKey;

    public static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
            keyPairGen.initialize(1024);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            return keyPair;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public static RSAPublicKey GetPublicKey(KeyPair keyPair) {
        return (RSAPublicKey)keyPair.getPublic();
    }

    public static RSAPrivateKey GetPrivateKey(KeyPair keyPair) {
        return (RSAPrivateKey)keyPair.getPrivate();
    }

    public static String encrypt(PublicKey publicKey, String plainText) throws Exception {
        try {
            int nLen = plainText.length();
            cipher.init(1, publicKey);
            ByteArrayOutputStream OutStream = new ByteArrayOutputStream();
            int nOffset = 0;
            while (nLen - nOffset > 0) {
                byte[] cache = nLen - nOffset >= 117 ? cipher.doFinal(plainText.getBytes(), nOffset, 117) : cipher.doFinal(plainText.getBytes(), nOffset, nLen - nOffset);
                OutStream.write(cache, 0, cache.length);
                nOffset += 117;
            }
            String EncryptDat = new BASE64Encoder().encode(OutStream.toByteArray());
            OutStream.close();
            return EncryptDat;
        }
        catch (InvalidKeyException e) {
            logger.error("", (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            logger.error("", (Throwable)e);
        }
        catch (BadPaddingException e) {
            logger.error("", (Throwable)e);
        }
        return null;
    }

    public static String decrypt(PrivateKey privateKey, String enStr) throws Exception {
        try {
            cipher.init(2, privateKey);
            byte[] EncryptData = new BASE64Decoder().decodeBuffer(enStr);
            int nLen = EncryptData.length;
            ByteArrayOutputStream OutStream = new ByteArrayOutputStream();
            int nOffset = 0;
            while (nLen - nOffset > 0) {
                byte[] cache = nLen - nOffset >= 128 ? cipher.doFinal(EncryptData, nOffset, 128) : cipher.doFinal(EncryptData, nOffset, nLen - nOffset);
                OutStream.write(cache, 0, cache.length);
                nOffset += 128;
            }
            String strOutData = OutStream.toString();
            OutStream.close();
            return strOutData;
        }
        catch (InvalidKeyException e) {
            logger.error("", (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            logger.error("", (Throwable)e);
        }
        catch (BadPaddingException e) {
            logger.error("", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        return null;
    }

    public static void InitializeRSA() throws Exception {
        KeyPair keyPair = RSAUtil.generateKeyPair();
        pubKey = RSAUtil.GetPublicKey(keyPair);
        priKey = RSAUtil.GetPrivateKey(keyPair);
    }

    public static String getModulus() {
        return pubKey.getModulus().toString(16);
    }

    public static int getExponent() {
        return pubKey.getPublicExponent().intValue();
    }

    public static String DecryptZKlicense(String EncryptData) throws Exception {
        return RSAUtil.decrypt(priKey, EncryptData);
    }

    public static void main(String[] args) throws Exception {
    }

    static {
        try {
            cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("", (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            logger.error("", (Throwable)e);
        }
    }
}

