/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.guard.license.bean;

import com.zkteco.zkbiosecurity.guard.LicenseUtil;
import com.zkteco.zkbiosecurity.guard.license.bean.Module;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;

public class ModuleBean {
    private String code;
    private final int licenseID;
    private final int controlCount;
    private final int limitNumberOfDays;
    private final int languagePack;
    private final int companyNameCrc16;
    private final int licenseType;
    private final int major;
    private final int minor;
    private final int module;
    private final int productCode;
    private final int extCode;
    private final boolean isTrial;
    private final Date trialFinishDate;
    private final Date licenseDate;
    public static final int UNLIMITED_VALUE = -1;
    public static final String DAYS_PATTERN = "yyyyMMdd";

    public int getExtCode() {
        return this.extCode;
    }

    public boolean isPull() {
        return this.code.equalsIgnoreCase(Module.MODULE_ACC_C3.getCode()) || this.code.equalsIgnoreCase(Module.MODULE_ACC_PULL.getCode());
    }

    public boolean isC3() {
        return this.code.equalsIgnoreCase(Module.MODULE_ACC_C3.getCode());
    }

    public boolean avaiable() {
        return this.licenseAvaiable() || this.trialAvaiable();
    }

    public boolean licenseAvaiable() {
        return this.getLeftLicenseDays() >= 0;
    }

    public boolean trialAvaiable() {
        return this.isTrial && LicenseUtil.getLeftTrialDay(this.code) > 0;
    }

    public int getTrialDays() {
        return LicenseUtil.getLeftTrialDay(this.code);
    }

    public int getLeftLicenseDays() {
        Date now = new Date();
        return LicenseUtil.getDaysBetween(now, this.licenseDate);
    }

    public ModuleBean(int licenseID, int controlCount, int limitNumberOfDays, int languagePack, int companyNameCrc16, int licenseType, int major, int minor, int module, int productCode, boolean isTrial, Date trialFinishDate, Date licenseDate, int extCode) {
        this.licenseID = licenseID;
        this.controlCount = controlCount;
        this.limitNumberOfDays = limitNumberOfDays;
        this.languagePack = languagePack;
        this.companyNameCrc16 = companyNameCrc16;
        this.licenseType = licenseType;
        this.major = major;
        this.minor = minor;
        this.module = module;
        this.productCode = productCode;
        this.isTrial = isTrial;
        this.trialFinishDate = trialFinishDate;
        this.extCode = extCode;
        Date d = null;
        if (licenseDate == null) {
            d = new Date();
            if (limitNumberOfDays > 0) {
                try {
                    d = DateUtils.parseDate((String)(limitNumberOfDays + ""), (String[])new String[]{DAYS_PATTERN});
                }
                catch (ParseException parseException) {}
            } else if (limitNumberOfDays == -1) {
                d = DateUtils.addYears((Date)d, (int)1000);
            }
            this.licenseDate = d;
        } else {
            this.licenseDate = licenseDate;
        }
    }

    public ModuleBean(int licenseID, int controlCount, int limitNumberOfDays, int languagePack, int companyNameCrc16, int licenseType, int major, int minor, int module, int productCode, boolean isTrial, Date trialFinishDate, Date licenseDate) {
        this(licenseID, controlCount, limitNumberOfDays, languagePack, companyNameCrc16, licenseType, major, minor, module, productCode, isTrial, trialFinishDate, licenseDate, 0);
    }

    public ModuleBean(String code, int controlCount, int module, boolean isTrial, Date trialFinishDate, int extCode) {
        this.code = code;
        this.controlCount = controlCount;
        this.module = module;
        this.isTrial = isTrial;
        this.trialFinishDate = trialFinishDate;
        this.licenseID = 0;
        this.limitNumberOfDays = 0;
        this.languagePack = -1;
        this.companyNameCrc16 = 0;
        this.licenseType = 0;
        this.major = 0;
        this.minor = 0;
        this.productCode = 0;
        this.licenseDate = DateUtils.addDays((Date)new Date(), (int)-1);
        this.extCode = extCode;
    }

    public ModuleBean(String code, int controlCount, int module, boolean isTrial, Date trialFinishDate) {
        this(code, controlCount, module, isTrial, trialFinishDate, 0);
    }

    public int getControlCount() {
        if (!this.avaiable()) {
            return 0;
        }
        if (this.controlCount > 0) {
            if (this.code.equals(Module.MODULE_VIS.getCode())) {
                return this.controlCount * 1000;
            }
            if (this.code.equals(Module.MODULE_VID.getCode()) && this.extCode == 8) {
                return this.controlCount * 100;
            }
            if (this.code.equals(Module.MODULE_ACC_PUSH.getCode()) && this.extCode == 8) {
                return this.controlCount * 100;
            }
        }
        return this.controlCount;
    }

    public int getDefaultControlCount() {
        if (this.controlCount > 0) {
            if (this.code.equals(Module.MODULE_VIS.getCode())) {
                return this.controlCount * 1000;
            }
            if (this.code.equals(Module.MODULE_VID.getCode()) && this.extCode == 8) {
                return this.controlCount * 100;
            }
            if (this.code.equals(Module.MODULE_ACC_PUSH.getCode()) && this.extCode == 8) {
                return this.controlCount * 100;
            }
        }
        return this.controlCount;
    }

    public int getLimitNumberOfDays() {
        if (this.limitNumberOfDays == -1) {
            Date d = DateUtils.addYears((Date)new Date(), (int)1000);
            String ds = new SimpleDateFormat(DAYS_PATTERN).format(d);
            return Integer.parseInt(ds);
        }
        return this.limitNumberOfDays;
    }

    public int getLanguagePack() {
        return this.languagePack;
    }

    public int getCompanyNameCrc16() {
        return this.companyNameCrc16;
    }

    public int getLicenseType() {
        return this.licenseType;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getModule() {
        return this.module;
    }

    public int getProductCode() {
        return this.productCode;
    }

    public boolean isTrial() {
        return this.isTrial;
    }

    public Date getTrialFinishDate() {
        return this.trialFinishDate;
    }

    public String getCode() {
        return this.code;
    }

    public int getLicenseID() {
        return this.licenseID;
    }

    public Date getLicenseDate() {
        return this.licenseDate;
    }

    public void setCode(String code) {
        this.code = code;
    }
}

