/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.controller;

import com.alibaba.fastjson.JSON;
import com.zkteco.zkbiosecurity.auth.remote.AuthUserRemote;
import com.zkteco.zkbiosecurity.auth.service.Auth4PersService;
import com.zkteco.zkbiosecurity.auth.service.AuthSecurityParamsService;
import com.zkteco.zkbiosecurity.auth.service.AuthSessionServcie;
import com.zkteco.zkbiosecurity.auth.service.AuthUserService;
import com.zkteco.zkbiosecurity.auth.vo.AuthUserImportItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthUserItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AuthUserController
extends ExportController
implements AuthUserRemote {
    @Autowired
    private AuthUserService authUserService;
    @Autowired
    private AuthSessionServcie authSessionServcie;
    @Autowired(required=false)
    private Auth4PersService auth4PersService;
    @Autowired
    private AuthSecurityParamsService authSecurityParamsService;

    @RequiresPermissions(value={"auth:user"})
    public ModelAndView index() {
        return new ModelAndView("auth/user/authUser");
    }

    @RequiresPermissions(value={"auth:user:refresh"})
    public DxGrid list(AuthUserItem codition) {
        Pager pager = this.authUserService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="system_module", object="auth_leftMenu_userManage", opType="common_op_del", requestParams={"usernames"}, opContent="auth_user_username")
    public ZKResultMsg delete(String ids) {
        ZKResultMsg resultMsg = this.authUserService.delByIds(WebContextUtil.getCurrentSessionId(), ids);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ModelAndView edit(String id, String editType, String newUser) {
        Map noMap;
        AuthUserItem authUserItem;
        String sessionId = this.request.getSession().getId();
        SecuritySubject securitySubject = this.authSessionServcie.getSecuritySubject(sessionId);
        String bioTemplateJson = "";
        if (StringUtils.isNotBlank((CharSequence)newUser)) {
            this.request.setAttribute("newUser", (Object)newUser);
        }
        if (StringUtils.isNotBlank((CharSequence)editType)) {
            this.request.setAttribute("editType", (Object)editType);
        }
        if ("PERS".equals(securitySubject.getLoginType()) && Objects.nonNull(this.auth4PersService)) {
            this.request.setAttribute("staff", (Object)"PERS");
            if (StringUtils.isNotBlank((CharSequence)id)) {
                authUserItem = this.auth4PersService.getPersById(id);
                Integer limit = authUserItem.getUserLoginLimit();
                if (!Objects.isNull(authUserItem) && !Objects.isNull(limit) && limit <= 0) {
                    authUserItem.setUserLoginLimit(null);
                }
                this.request.setAttribute("item", (Object)authUserItem);
                this.request.setAttribute("loginUser", (Object)authUserItem);
            }
        } else if ("NORMAL".equals(securitySubject.getLoginType())) {
            if (StringUtils.isNotBlank((CharSequence)id)) {
                authUserItem = this.authUserService.getItemById(id);
                Integer limit = authUserItem.getUserLoginLimit();
                if (!Objects.isNull(authUserItem) && !Objects.isNull(limit) && limit <= 0) {
                    authUserItem.setUserLoginLimit(null);
                }
                this.request.setAttribute("item", (Object)authUserItem);
                bioTemplateJson = JSON.toJSONString((Object)this.authUserService.getAuthBioMapByAuthId(id));
                this.request.setAttribute("bioTemplateJson", (Object)bioTemplateJson);
            }
            AuthUserItem loginUserItem = this.authUserService.getLoginUser(this.request.getSession().getId());
            this.request.setAttribute("loginUser", (Object)loginUserItem);
        }
        if ((noMap = this.authSecurityParamsService.getParams("passwordStrengthLevel")) != null && StringUtils.isNotBlank((CharSequence)((CharSequence)noMap.get("passwordStrengthLevel")))) {
            this.request.setAttribute("pwdInfoNo", noMap.get("passwordStrengthLevel"));
        }
        return new ModelAndView("auth/user/editAuthUser");
    }

    @LogRequest(module="system_module", object="auth_leftMenu_userManage", opType="common_op_edit", requestParams={"username"}, opContent="auth_user_username")
    public ZKResultMsg save(AuthUserItem item, @RequestParam(value="newUser", required=false) String newUser) {
        ZKResultMsg res = new ZKResultMsg();
        SecuritySubject subject = this.authSessionServcie.getSecuritySubject(this.request.getSession().getId());
        if (item.getIsSuperuser() != null && item.getIsSuperuser().booleanValue() && (subject.getIsSuperuser() == null || !subject.getIsSuperuser().booleanValue())) {
            throw new ZKBusinessException("auth_login_onlyAdminLogn");
        }
        if (item.getLoginPwd() != null && !item.getLoginPwd().equals(item.getRepassword())) {
            throw new ZKBusinessException("auth_user_rpwdMsg");
        }
        String loginType = subject.getLoginType();
        if (item.getUserLoginLimit() == null) {
            item.setUserLoginLimit(Integer.valueOf(-1));
        }
        if ("PERS".equals(loginType) && Objects.nonNull(this.auth4PersService)) {
            this.auth4PersService.saveItem(item);
        } else if ("NORMAL".equals(loginType)) {
            this.authUserService.saveItem(item);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public String valid(String username) {
        boolean ret = this.authUserService.isExistUserName(username);
        return !ret + "";
    }

    public String verifyLoginPwd(String loginPwd) {
        return "" + this.authUserService.verifyLoginPwd(WebContextUtil.getCurrentSessionId(), loginPwd);
    }

    public String verifySecurity(String loginPwd, String mode) {
        return "" + this.authUserService.verifySecurity(WebContextUtil.getCurrentSessionId(), loginPwd, mode);
    }

    @RequiresPermissions(value={"auth:user:import"})
    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        List itemList = ExcelUtil.excelImport((InputStream)upload.getInputStream(), AuthUserImportItem.class);
        ZKResultMsg res = this.authUserService.importData(itemList);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"auth:user:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        String exportType = request.getParameter("exportType");
        String recordStart = request.getParameter("recordstart");
        String recordCount = request.getParameter("recordcount");
        AuthUserItem authUserItem = new AuthUserItem();
        this.setConditionValue((BaseItem)authUserItem);
        int beginIndex = 0;
        int endIndex = 30000;
        if (exportType.equals("3") && StringUtils.isNotBlank((CharSequence)recordStart) && StringUtils.isNotBlank((CharSequence)recordCount)) {
            beginIndex = Integer.valueOf(recordStart);
            beginIndex = beginIndex > 0 ? beginIndex - 1 : 0;
            int maxCount = Integer.valueOf(recordCount) > 30000 ? 30000 : Integer.valueOf(recordCount);
            endIndex = beginIndex + maxCount - 1;
        }
        List itemList = this.authUserService.getItemData(AuthUserItem.class, authUserItem, beginIndex, endIndex);
        this.excelExport(itemList, AuthUserItem.class);
    }
}

