/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.controller;

import com.zkteco.zkbiosecurity.auth.remote.AuthApiTokenRemote;
import com.zkteco.zkbiosecurity.auth.service.AuthApiTokenService;
import com.zkteco.zkbiosecurity.auth.vo.AuthApiTokenItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.license.provider.BaseLicenseProvider;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AuthApiTokenController
extends BaseController
implements AuthApiTokenRemote {
    @Autowired
    private AuthApiTokenService authApiTokenService;
    @Autowired
    private BaseLicenseProvider baseLicenseProvider;
    @Value(value="${system.language:zh_CN}")
    private String language;

    @RequiresPermissions(value={"auth:apiToken"})
    public ModelAndView index() {
        boolean apiShow = true;
        if (!this.language.equals("zh_CN")) {
            apiShow = this.baseLicenseProvider.licenseAvaiable("api");
        }
        this.request.setAttribute("apiShow", (Object)apiShow);
        return new ModelAndView("auth/apiToken/authApiToken");
    }

    @RequiresPermissions(value={"auth:apiToken:add", "auth:apiToken:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AuthApiTokenItem authApiTokenItem = this.authApiTokenService.getItemById(id);
            this.request.setAttribute("item", (Object)authApiTokenItem);
            this.request.setAttribute("editPage", (Object)true);
        }
        return new ModelAndView("auth/apiToken/editAuthApiToken");
    }

    @LogRequest(module="system_module", object="auth_leftMenu_thirdParty", opType="common_op_edit", requestParams={"clientName"}, opContent="auth_clientDetails_clientId")
    @RequiresPermissions(value={"auth:apiToken:add", "auth:apiToken:edit"})
    public ZKResultMsg save(AuthApiTokenItem item) {
        this.authApiTokenService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"auth:apiToken:refresh"})
    public DxGrid list(AuthApiTokenItem condition) {
        Pager pager = this.authApiTokenService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @LogRequest(module="system_module", object="auth_leftMenu_thirdParty", opType="common_op_del", requestParams={"clientName"}, opContent="auth_clientDetails_clientId")
    @RequiresPermissions(value={"auth:apiToken:del"})
    public ZKResultMsg delete(String ids) {
        this.authApiTokenService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public ZKResultMsg generateApiToken(String clientName) {
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        String token = this.authApiTokenService.generateApiToken(clientName);
        resultMsg.setData((Object)token);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public boolean isExistClientName(String clientName) {
        return this.authApiTokenService.isExistClientName(clientName);
    }
}

