/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.vis.remote.VisWatchListSelectRemote;
import com.zkteco.zkbiosecurity.vis.service.VisTransactionService;
import com.zkteco.zkbiosecurity.vis.service.VisWatchListSelectService;
import com.zkteco.zkbiosecurity.vis.vo.VisTransactionItem;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitorItem;
import com.zkteco.zkbiosecurity.vis.vo.VisWatchListSelectItem;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
public class VisWatchListSelectController
extends BaseController
implements VisWatchListSelectRemote {
    @Autowired
    private VisWatchListSelectService visWatchListSelectService;
    @Autowired
    private VisTransactionService visTransactionService;

    public DxGrid list(VisWatchListSelectItem condition) {
        Pager pager = new Pager();
        if (condition.getType().equals("noSelected")) {
            pager = this.visWatchListSelectService.getNoSelectPerson(condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg visitorInfo(String id) {
        ZKResultMsg zkResultMsg = ZKResultMsg.successMsg();
        VisVisitorItem item = this.visWatchListSelectService.getVisitorInfoById(id);
        if (item != null && StringUtils.isNotBlank((CharSequence)item.getPin())) {
            VisTransactionItem transactionItem = this.visTransactionService.getItemByPinAndState(item.getPin());
            if (transactionItem != null) {
                item.setCertPhoto(transactionItem.getEnterPhoto());
            }
            zkResultMsg.setData((Object)item);
        } else {
            zkResultMsg.setData((Object)new VisVisitorItem());
        }
        return zkResultMsg;
    }

    public ModelAndView index() {
        return new ModelAndView("vis/watchList/watchListSelectContent");
    }
}

