/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttMonthStatisticalReportRemote;
import com.zkteco.zkbiosecurity.att.service.AttMonthStatisticalReportService;
import com.zkteco.zkbiosecurity.att.service.AttRecordService;
import com.zkteco.zkbiosecurity.att.vo.AttMonthStatisticalReportItem;
import com.zkteco.zkbiosecurity.auth.service.AuthDepartmentService;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttMonthStatisticalReportController
extends ExportController
implements AttMonthStatisticalReportRemote {
    @Autowired
    private AttMonthStatisticalReportService attMonthStatisticalReportService;
    @Autowired
    private AttRecordService attRecordService;
    @Autowired(required=false)
    private AuthDepartmentService authDepartmentService;

    @RequiresPermissions(value={"att:monthStatisticalReport"})
    public ModelAndView index() {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        this.request.setAttribute("staff", (Object)staff);
        return new ModelAndView("att/report/attMonthStatistical");
    }

    @RequiresPermissions(value={"att:monthStatisticalReport:refresh"})
    public DxGrid list(AttMonthStatisticalReportItem condition) {
        Pager pager = this.attMonthStatisticalReportService.loadPagerByAuthUserFilter(this.request.getSession().getId(), (BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:monthStatisticalReport:export"})
    @LogRequest(module="att_module", object="att_leftMenu_monthStatisticalReport", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttMonthStatisticalReportItem attMonthStatisticalReportItem = new AttMonthStatisticalReportItem();
        this.setConditionValue((BaseItem)attMonthStatisticalReportItem);
        List itemList = this.attRecordService.getMonthStatisticalReportItemData(request.getSession().getId(), AttMonthStatisticalReportItem.class, (BaseItem)attMonthStatisticalReportItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, AttMonthStatisticalReportItem.class);
    }
}

