/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.api.controller;

import com.alibaba.fastjson.JSONArray;
import com.zkteco.zkbiosecurity.att.service.AttTransactionService;
import com.zkteco.zkbiosecurity.base.annotation.ApiPermissions;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/transaction"})
@Api(tags={"AttTransaction"}, description="att transaction")
public class AttApiTransactionController {
    @Autowired
    private AttTransactionService attTransactionService;

    @ResponseBody
    @RequestMapping(value={"/listAttTransaction"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Att Transactions List", notes="Return Att Transactions List", response=ApiResultMessage.class)
    public ApiResultMessage listAttTransaction(@RequestParam(required=false) String personPin, @RequestParam(required=false) String startDate, @RequestParam(required=false) String endDate, @RequestParam Integer pageNo, @RequestParam Integer pageSize) {
        Date startTime = null;
        Date endTime = null;
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-91, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            startTime = DateUtil.stringToDate((String)startDate);
            endTime = DateUtil.stringToDate((String)endDate);
            if (startTime == null || endTime == null) {
                return ApiResultMessage.message((int)-100, (String)I18nUtil.i18nCode((String)"common_dsTime_timeValid2", (Object[])new Object[0]));
            }
            if (startTime.getTime() > endTime.getTime()) {
                return ApiResultMessage.message((int)-101, (String)I18nUtil.i18nCode((String)"common_dsTime_timeValid4", (Object[])new Object[0]));
            }
        }
        List attApiTransactionItemList = this.attTransactionService.getApiTransactionList(personPin, startTime, endTime, pageNo.intValue(), pageSize.intValue());
        return ApiResultMessage.successMessage((Object)attApiTransactionItemList);
    }

    @RequestMapping(value={"/getPersonAttTrans"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    @ApiPermissions(moduleCode="att", moduleName="att_module")
    public ZKResultMsg getPersonAttTrans(@RequestBody ZKMessage zkMessage) {
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        try {
            Map content = zkMessage.getContent();
            Integer pageNo = MapUtils.getInteger((Map)content, (Object)"pageNo");
            Integer pageSize = MapUtils.getInteger((Map)content, (Object)"pageSize");
            String startDate = MapUtils.getString((Map)content, (Object)"startDate");
            String endDate = MapUtils.getString((Map)content, (Object)"endDate");
            String personPin = MapUtils.getString((Map)content, (Object)"personPin");
            Date startTime = null;
            Date endTime = null;
            if (pageNo == null) {
                pageNo = 1;
            }
            if (pageSize == null) {
                pageSize = 50;
            }
            if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
                startTime = DateUtil.stringToDate((String)startDate);
                endTime = DateUtil.stringToDate((String)endDate);
                List attApiTransactionItemList = this.attTransactionService.getApiTransactionList(personPin, startTime, endTime, pageNo.intValue(), pageSize.intValue());
                resultMsg.setData((Object)JSONArray.toJSONString((Object)attApiTransactionItemList));
            }
        }
        catch (Exception e) {
            resultMsg = ZKResultMsg.failMsg();
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }
}

