/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLProtocolException;
import sun.security.internal.spec.TlsPrfParameterSpec;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.Debug;
import sun.security.ssl.ECDHCrypt;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HelloExtension;
import sun.security.ssl.HelloExtensions;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.RSASignature;
import sun.security.ssl.RandomCookie;
import sun.security.ssl.RenegotiationInfoExtension;
import sun.security.ssl.ServerNameExtension;
import sun.security.ssl.SessionId;
import sun.security.ssl.SignatureAlgorithmsExtension;
import sun.security.ssl.SignatureAndHashAlgorithm;
import sun.security.ssl.SupportedEllipticCurvesExtension;
import sun.security.ssl.SupportedEllipticPointFormatsExtension;

public abstract class HandshakeMessage {
    static final byte ht_hello_request = 0;
    static final byte ht_client_hello = 1;
    static final byte ht_server_hello = 2;
    static final byte ht_certificate = 11;
    static final byte ht_server_key_exchange = 12;
    static final byte ht_certificate_request = 13;
    static final byte ht_server_hello_done = 14;
    static final byte ht_certificate_verify = 15;
    static final byte ht_client_key_exchange = 16;
    static final byte ht_finished = 20;
    public static final Debug debug = Debug.getInstance("ssl");
    static final byte[] MD5_pad1 = HandshakeMessage.genPad(54, 48);
    static final byte[] MD5_pad2 = HandshakeMessage.genPad(92, 48);
    static final byte[] SHA_pad1 = HandshakeMessage.genPad(54, 40);
    static final byte[] SHA_pad2 = HandshakeMessage.genPad(92, 40);

    HandshakeMessage() {
    }

    static byte[] toByteArray(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length > 1 && byArray[0] == 0) {
            int n = byArray.length - 1;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 1, byArray2, 0, n);
            byArray = byArray2;
        }
        return byArray;
    }

    private static byte[] genPad(int n, int n2) {
        byte[] byArray = new byte[n2];
        Arrays.fill(byArray, (byte)n);
        return byArray;
    }

    final void write(HandshakeOutStream handshakeOutStream) throws IOException {
        int n = this.messageLength();
        if (n >= 0x1000000) {
            throw new SSLException("Handshake message too big, type = " + this.messageType() + ", len = " + n);
        }
        handshakeOutStream.write(this.messageType());
        handshakeOutStream.putInt24(n);
        this.send(handshakeOutStream);
    }

    abstract int messageType();

    abstract int messageLength();

    abstract void send(HandshakeOutStream var1) throws IOException;

    abstract void print(PrintStream var1) throws IOException;

    static final class CertificateMsg
    extends HandshakeMessage {
        private X509Certificate[] chain;
        private List<byte[]> encodedChain;
        private int messageLength;

        @Override
        int messageType() {
            return 11;
        }

        CertificateMsg(X509Certificate[] x509CertificateArray) {
            this.chain = x509CertificateArray;
        }

        CertificateMsg(HandshakeInStream handshakeInStream) throws IOException {
            int n = handshakeInStream.getInt24();
            ArrayList<Certificate> arrayList = new ArrayList<Certificate>(4);
            CertificateFactory certificateFactory = null;
            while (n > 0) {
                byte[] byArray = handshakeInStream.getBytes24();
                n -= 3 + byArray.length;
                try {
                    if (certificateFactory == null) {
                        certificateFactory = CertificateFactory.getInstance("X.509");
                    }
                    arrayList.add(certificateFactory.generateCertificate(new ByteArrayInputStream(byArray)));
                }
                catch (CertificateException certificateException) {
                    throw (SSLProtocolException)new SSLProtocolException(certificateException.getMessage()).initCause(certificateException);
                }
            }
            this.chain = arrayList.toArray(new X509Certificate[arrayList.size()]);
        }

        @Override
        int messageLength() {
            if (this.encodedChain == null) {
                this.messageLength = 3;
                this.encodedChain = new ArrayList<byte[]>(this.chain.length);
                try {
                    for (X509Certificate x509Certificate : this.chain) {
                        byte[] byArray = x509Certificate.getEncoded();
                        this.encodedChain.add(byArray);
                        this.messageLength += byArray.length + 3;
                    }
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    this.encodedChain = null;
                    throw new RuntimeException("Could not encode certificates", certificateEncodingException);
                }
            }
            return this.messageLength;
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putInt24(this.messageLength() - 3);
            for (byte[] byArray : this.encodedChain) {
                handshakeOutStream.putBytes24(byArray);
            }
        }

        @Override
        void print(PrintStream printStream) throws IOException {
            printStream.println("*** Certificate chain");
            if (debug != null && Debug.isOn("verbose")) {
                for (int i = 0; i < this.chain.length; ++i) {
                    printStream.println("chain [" + i + "] = " + this.chain[i]);
                }
                printStream.println("***");
            }
        }

        X509Certificate[] getCertificateChain() {
            return (X509Certificate[])this.chain.clone();
        }
    }

    static final class ClientHello
    extends HandshakeMessage {
        ProtocolVersion protocolVersion;
        RandomCookie clnt_random;
        SessionId sessionId;
        private CipherSuiteList cipherSuites;
        byte[] compression_methods;
        HelloExtensions extensions = new HelloExtensions();
        private static final byte[] NULL_COMPRESSION = new byte[]{0};

        ClientHello(SecureRandom secureRandom, ProtocolVersion protocolVersion, SessionId sessionId, CipherSuiteList cipherSuiteList) {
            this.protocolVersion = protocolVersion;
            this.sessionId = sessionId;
            this.cipherSuites = cipherSuiteList;
            if (cipherSuiteList.containsEC()) {
                this.extensions.add(SupportedEllipticCurvesExtension.DEFAULT);
                this.extensions.add(SupportedEllipticPointFormatsExtension.DEFAULT);
            }
            this.clnt_random = new RandomCookie(secureRandom);
            this.compression_methods = NULL_COMPRESSION;
        }

        ClientHello(HandshakeInStream handshakeInStream, int n) throws IOException {
            this.protocolVersion = ProtocolVersion.valueOf(handshakeInStream.getInt8(), handshakeInStream.getInt8());
            this.clnt_random = new RandomCookie(handshakeInStream);
            this.sessionId = new SessionId(handshakeInStream.getBytes8());
            this.cipherSuites = new CipherSuiteList(handshakeInStream);
            this.compression_methods = handshakeInStream.getBytes8();
            if (this.messageLength() != n) {
                this.extensions = new HelloExtensions(handshakeInStream);
            }
        }

        CipherSuiteList getCipherSuites() {
            return this.cipherSuites;
        }

        void addRenegotiationInfoExtension(byte[] byArray) {
            RenegotiationInfoExtension renegotiationInfoExtension = new RenegotiationInfoExtension(byArray, new byte[0]);
            this.extensions.add(renegotiationInfoExtension);
        }

        void addServerNameIndicationExtension(String string) {
            ArrayList<String> arrayList = new ArrayList<String>(1);
            arrayList.add(string);
            try {
                this.extensions.add((HelloExtension)((Object)new ServerNameExtension(arrayList)));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void addSignatureAlgorithmsExtension(Collection<SignatureAndHashAlgorithm> collection) {
            SignatureAlgorithmsExtension signatureAlgorithmsExtension = new SignatureAlgorithmsExtension(collection);
            this.extensions.add((HelloExtension)((Object)signatureAlgorithmsExtension));
        }

        @Override
        int messageType() {
            return 1;
        }

        @Override
        int messageLength() {
            return 38 + this.sessionId.length() + this.cipherSuites.size() * 2 + this.compression_methods.length + this.extensions.length();
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putInt8(this.protocolVersion.major);
            handshakeOutStream.putInt8(this.protocolVersion.minor);
            this.clnt_random.send(handshakeOutStream);
            handshakeOutStream.putBytes8(this.sessionId.getId());
            this.cipherSuites.send(handshakeOutStream);
            handshakeOutStream.putBytes8(this.compression_methods);
            this.extensions.send(handshakeOutStream);
        }

        @Override
        void print(PrintStream printStream) throws IOException {
            printStream.println("*** ClientHello, " + this.protocolVersion);
            if (debug != null && Debug.isOn("verbose")) {
                printStream.print("RandomCookie:  ");
                this.clnt_random.print(printStream);
                printStream.print("Session ID:  ");
                printStream.println(this.sessionId);
                printStream.println("Cipher Suites: " + this.cipherSuites);
                Debug.println(printStream, "Compression Methods", this.compression_methods);
                this.extensions.print(printStream);
                printStream.println("***");
            }
        }
    }

    static final class ECDH_ServerKeyExchange
    extends ServerKeyExchange {
        private static final int CURVE_EXPLICIT_PRIME = 1;
        private static final int CURVE_EXPLICIT_CHAR2 = 2;
        private static final int CURVE_NAMED_CURVE = 3;
        private int curveId;
        private byte[] pointBytes;
        private byte[] signatureBytes;
        private ECPublicKey publicKey;
        ProtocolVersion protocolVersion;
        private SignatureAndHashAlgorithm preferableSignatureAlgorithm;

        ECDH_ServerKeyExchange(ECDHCrypt eCDHCrypt, PrivateKey privateKey, byte[] byArray, byte[] byArray2, SecureRandom secureRandom, SignatureAndHashAlgorithm signatureAndHashAlgorithm, ProtocolVersion protocolVersion) throws GeneralSecurityException {
            Signature signature;
            this.protocolVersion = protocolVersion;
            this.publicKey = (ECPublicKey)eCDHCrypt.getPublicKey();
            ECParameterSpec eCParameterSpec = this.publicKey.getParams();
            ECPoint eCPoint = this.publicKey.getW();
            this.pointBytes = JsseJce.encodePoint(eCPoint, eCParameterSpec.getCurve());
            this.curveId = SupportedEllipticCurvesExtension.getCurveIndex(eCParameterSpec);
            if (privateKey == null) {
                return;
            }
            if (protocolVersion.v >= ProtocolVersion.TLS12.v) {
                this.preferableSignatureAlgorithm = signatureAndHashAlgorithm;
                signature = JsseJce.getSignature(signatureAndHashAlgorithm.getAlgorithmName());
            } else {
                signature = ECDH_ServerKeyExchange.getSignature(privateKey.getAlgorithm());
            }
            signature.initSign(privateKey);
            this.updateSignature(signature, byArray, byArray2);
            this.signatureBytes = signature.sign();
        }

        ECDH_ServerKeyExchange(HandshakeInStream handshakeInStream, PublicKey publicKey, byte[] byArray, byte[] byArray2, Collection<SignatureAndHashAlgorithm> collection, ProtocolVersion protocolVersion) throws IOException, GeneralSecurityException {
            ECParameterSpec eCParameterSpec;
            Object object;
            this.protocolVersion = protocolVersion;
            int n = handshakeInStream.getInt8();
            if (n == 3) {
                this.curveId = handshakeInStream.getInt16();
                if (!SupportedEllipticCurvesExtension.isSupported(this.curveId)) {
                    throw new SSLHandshakeException("Unsupported curveId: " + this.curveId);
                }
                object = SupportedEllipticCurvesExtension.getCurveOid(this.curveId);
                if (object == null) {
                    throw new SSLHandshakeException("Unknown named curve: " + this.curveId);
                }
                eCParameterSpec = JsseJce.getECParameterSpec((String)object);
                if (eCParameterSpec == null) {
                    throw new SSLHandshakeException("Unsupported curve: " + (String)object);
                }
            } else {
                throw new SSLHandshakeException("Unsupported ECCurveType: " + n);
            }
            this.pointBytes = handshakeInStream.getBytes8();
            object = JsseJce.decodePoint(this.pointBytes, eCParameterSpec.getCurve());
            KeyFactory keyFactory = JsseJce.getKeyFactory("EC");
            this.publicKey = (ECPublicKey)keyFactory.generatePublic(new ECPublicKeySpec((ECPoint)object, eCParameterSpec));
            if (publicKey == null) {
                return;
            }
            if (protocolVersion.v >= ProtocolVersion.TLS12.v) {
                int n2 = handshakeInStream.getInt8();
                int n3 = handshakeInStream.getInt8();
                this.preferableSignatureAlgorithm = SignatureAndHashAlgorithm.valueOf(n2, n3, 0);
                if (!collection.contains(this.preferableSignatureAlgorithm)) {
                    throw new SSLHandshakeException("Unsupported SignatureAndHashAlgorithm in ServerKeyExchange message");
                }
            }
            this.signatureBytes = handshakeInStream.getBytes16();
            Signature signature = protocolVersion.v >= ProtocolVersion.TLS12.v ? JsseJce.getSignature(this.preferableSignatureAlgorithm.getAlgorithmName()) : ECDH_ServerKeyExchange.getSignature(publicKey.getAlgorithm());
            signature.initVerify(publicKey);
            this.updateSignature(signature, byArray, byArray2);
            if (!signature.verify(this.signatureBytes)) {
                throw new SSLKeyException("Invalid signature on ECDH server key exchange message");
            }
        }

        ECPublicKey getPublicKey() {
            return this.publicKey;
        }

        private static Signature getSignature(String string) throws NoSuchAlgorithmException {
            if (string.equals("EC")) {
                return JsseJce.getSignature("SHA1withECDSA");
            }
            if (string.equals("RSA")) {
                return RSASignature.getInstance();
            }
            throw new NoSuchAlgorithmException("neither an RSA or a EC key");
        }

        private void updateSignature(Signature signature, byte[] byArray, byte[] byArray2) throws SignatureException {
            signature.update(byArray);
            signature.update(byArray2);
            signature.update((byte)3);
            signature.update((byte)(this.curveId >> 8));
            signature.update((byte)this.curveId);
            signature.update((byte)this.pointBytes.length);
            signature.update(this.pointBytes);
        }

        @Override
        int messageLength() {
            int n = 0;
            if (this.signatureBytes != null) {
                n = 2 + this.signatureBytes.length;
                if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                    n += SignatureAndHashAlgorithm.sizeInRecord();
                }
            }
            return 4 + this.pointBytes.length + n;
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putInt8(3);
            handshakeOutStream.putInt16(this.curveId);
            handshakeOutStream.putBytes8(this.pointBytes);
            if (this.signatureBytes != null) {
                if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                    handshakeOutStream.putInt8(this.preferableSignatureAlgorithm.getHashValue());
                    handshakeOutStream.putInt8(this.preferableSignatureAlgorithm.getSignatureValue());
                }
                handshakeOutStream.putBytes16(this.signatureBytes);
            }
        }

        @Override
        void print(PrintStream printStream) throws IOException {
            printStream.println("*** ECDH ServerKeyExchange");
            if (debug != null && Debug.isOn("verbose")) {
                if (this.signatureBytes == null) {
                    printStream.println("Anonymous");
                } else if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                    printStream.println("Signature Algorithm " + this.preferableSignatureAlgorithm.getAlgorithmName());
                }
                printStream.println("Server key: " + this.publicKey);
            }
        }
    }

    /*
     * Exception performing whole class analysis ignored.
     */
    static final class Finished
    extends HandshakeMessage {
        static final int CLIENT = 1;
        static final int SERVER = 2;
        private static final byte[] SSL_CLIENT = new byte[]{67, 76, 78, 84};
        private static final byte[] SSL_SERVER = new byte[]{83, 82, 86, 82};
        private byte[] verifyData;
        private ProtocolVersion protocolVersion;
        private CipherSuite cipherSuite;

        Finished(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, int n, SecretKey secretKey, CipherSuite cipherSuite) {
            this.protocolVersion = protocolVersion;
            this.cipherSuite = cipherSuite;
            this.verifyData = this.getFinished(handshakeHash, n, secretKey);
        }

        Finished(ProtocolVersion protocolVersion, HandshakeInStream handshakeInStream, CipherSuite cipherSuite) throws IOException {
            this.protocolVersion = protocolVersion;
            this.cipherSuite = cipherSuite;
            int n = protocolVersion.v >= ProtocolVersion.TLS10.v ? 12 : 36;
            this.verifyData = new byte[n];
            handshakeInStream.read(this.verifyData);
        }

        boolean verify(HandshakeHash handshakeHash, int n, SecretKey secretKey) {
            byte[] byArray = this.getFinished(handshakeHash, n, secretKey);
            return Arrays.equals(byArray, this.verifyData);
        }

        private byte[] getFinished(HandshakeHash handshakeHash, int n, SecretKey secretKey) {
            String string;
            byte[] byArray;
            if (n == 1) {
                byArray = SSL_CLIENT;
                string = "client finished";
            } else if (n == 2) {
                byArray = SSL_SERVER;
                string = "server finished";
            } else {
                throw new RuntimeException("Invalid sender: " + n);
            }
            if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
                try {
                    Object object;
                    CipherSuite.PRF pRF;
                    String string2;
                    byte[] byArray2;
                    if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                        byArray2 = handshakeHash.getFinishedHash();
                        string2 = "SunTls12Prf";
                        pRF = this.cipherSuite.prfAlg;
                    } else {
                        object = handshakeHash.getMD5Clone();
                        MessageDigest messageDigest = handshakeHash.getSHAClone();
                        byArray2 = new byte[36];
                        ((MessageDigest)object).digest(byArray2, 0, 16);
                        messageDigest.digest(byArray2, 16, 20);
                        string2 = "SunTlsPrf";
                        pRF = CipherSuite.PRF.P_NONE;
                    }
                    object = pRF.getPRFHashAlg();
                    int n2 = pRF.getPRFHashLength();
                    int n3 = pRF.getPRFBlockSize();
                    TlsPrfParameterSpec tlsPrfParameterSpec = new TlsPrfParameterSpec(secretKey, string, byArray2, 12, (String)object, n2, n3);
                    KeyGenerator keyGenerator = JsseJce.getKeyGenerator(string2);
                    keyGenerator.init(tlsPrfParameterSpec);
                    SecretKey secretKey2 = keyGenerator.generateKey();
                    if (!"RAW".equals(secretKey2.getFormat())) {
                        throw new ProviderException("Invalid PRF output, format must be RAW");
                    }
                    byte[] byArray3 = secretKey2.getEncoded();
                    return byArray3;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new RuntimeException("PRF failed", generalSecurityException);
                }
            }
            MessageDigest messageDigest = handshakeHash.getMD5Clone();
            MessageDigest messageDigest2 = handshakeHash.getSHAClone();
            Finished.updateDigest(messageDigest, byArray, MD5_pad1, MD5_pad2, secretKey);
            Finished.updateDigest(messageDigest2, byArray, SHA_pad1, SHA_pad2, secretKey);
            byte[] byArray4 = new byte[36];
            try {
                messageDigest.digest(byArray4, 0, 16);
                messageDigest2.digest(byArray4, 16, 20);
            }
            catch (DigestException digestException) {
                throw new RuntimeException("Digest failed", digestException);
            }
            return byArray4;
        }

        private static void updateDigest(MessageDigest messageDigest, byte[] byArray, byte[] byArray2, byte[] byArray3, SecretKey secretKey) {
            messageDigest.update(byArray);
            CertificateVerify.access$000((MessageDigest)messageDigest, (byte[])byArray2, (byte[])byArray3, (SecretKey)secretKey);
        }

        byte[] getVerifyData() {
            return this.verifyData;
        }

        @Override
        int messageType() {
            return 20;
        }

        @Override
        int messageLength() {
            return this.verifyData.length;
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.write(this.verifyData);
        }

        @Override
        void print(PrintStream printStream) throws IOException {
            printStream.println("*** Finished");
            if (debug != null && Debug.isOn("verbose")) {
                Debug.println(printStream, "verify_data", this.verifyData);
                printStream.println("***");
            }
        }
    }

    static final class ServerHello
    extends HandshakeMessage {
        ProtocolVersion protocolVersion;
        RandomCookie svr_random;
        SessionId sessionId;
        CipherSuite cipherSuite;
        byte compression_method;
        HelloExtensions extensions = new HelloExtensions();

        @Override
        int messageType() {
            return 2;
        }

        ServerHello() {
        }

        ServerHello(HandshakeInStream handshakeInStream, int n) throws IOException {
            this.protocolVersion = ProtocolVersion.valueOf(handshakeInStream.getInt8(), handshakeInStream.getInt8());
            this.svr_random = new RandomCookie(handshakeInStream);
            this.sessionId = new SessionId(handshakeInStream.getBytes8());
            this.cipherSuite = CipherSuite.valueOf(handshakeInStream.getInt8(), handshakeInStream.getInt8());
            this.compression_method = (byte)handshakeInStream.getInt8();
            if (this.messageLength() != n) {
                this.extensions = new HelloExtensions(handshakeInStream);
            }
        }

        @Override
        int messageLength() {
            return 38 + this.sessionId.length() + this.extensions.length();
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putInt8(this.protocolVersion.major);
            handshakeOutStream.putInt8(this.protocolVersion.minor);
            this.svr_random.send(handshakeOutStream);
            handshakeOutStream.putBytes8(this.sessionId.getId());
            handshakeOutStream.putInt8(this.cipherSuite.id >> 8);
            handshakeOutStream.putInt8(this.cipherSuite.id & 0xFF);
            handshakeOutStream.putInt8(this.compression_method);
            this.extensions.send(handshakeOutStream);
        }

        @Override
        void print(PrintStream printStream) throws IOException {
            printStream.println("*** ServerHello, " + this.protocolVersion);
            if (debug != null && Debug.isOn("verbose")) {
                printStream.print("RandomCookie:  ");
                this.svr_random.print(printStream);
                printStream.print("Session ID:  ");
                printStream.println(this.sessionId);
                printStream.println("Cipher Suite: " + this.cipherSuite);
                printStream.println("Compression Method: " + this.compression_method);
                this.extensions.print(printStream);
                printStream.println("***");
            }
        }
    }

    static final class ServerHelloDone
    extends HandshakeMessage {
        @Override
        int messageType() {
            return 14;
        }

        ServerHelloDone() {
        }

        ServerHelloDone(HandshakeInStream handshakeInStream) {
        }

        @Override
        int messageLength() {
            return 0;
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
        }

        @Override
        void print(PrintStream printStream) throws IOException {
            printStream.println("*** ServerHelloDone");
        }
    }

    static abstract class ServerKeyExchange
    extends HandshakeMessage {
        ServerKeyExchange() {
        }

        @Override
        int messageType() {
            return 12;
        }
    }
}

