/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.api.controller;

import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.api.vo.PersApiPersonItem;
import com.zkteco.zkbiosecurity.pers.service.PersApiPersonService;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/person"})
@Api(tags={"Person"}, description="person")
public class PersApiPersonController {
    private static final Logger log = LoggerFactory.getLogger(PersApiPersonController.class);
    @Autowired
    private PersApiPersonService persApiPersonService;
    @Autowired
    private PersPersonService persPersonService;

    @ApiOperation(value="Add Person", notes="Create Or Update Person", response=ApiResultMessage.class)
    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage addPerson(@RequestBody PersApiPersonItem person) {
        ApiResultMessage rs = null;
        try {
            rs = this.persApiPersonService.addApiPerson(person);
        }
        catch (Exception e) {
            log.error("api person/add error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    @ApiOperation(value="Delete Person", notes="Delete Person By Pin", response=ApiResultMessage.class)
    @RequestMapping(value={"/delete/{pin}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage deleteByPin(@PathVariable String pin) {
        ApiResultMessage rs = new ApiResultMessage();
        if (StringUtils.isBlank((CharSequence)pin)) {
            return ApiResultMessage.message((int)-20, (String)I18nUtil.i18nCode((String)"pers_import_pinNotEmpty", (Object[])new Object[0]));
        }
        try {
            PersPersonItem persPersonItem = this.persPersonService.getItemByPin(pin);
            if (persPersonItem == null) {
                return ApiResultMessage.message((int)-22, (String)I18nUtil.i18nCode((String)"pers_api_personNotExist", (Object[])new Object[0]));
            }
            this.persPersonService.deleteByIds(persPersonItem.getId());
        }
        catch (ZKBusinessException e) {
            rs = ApiResultMessage.message((int)-35, (String)I18nUtil.i18nCode((String)e.getMessage(), (Object[])new Object[0]));
        }
        catch (Exception e) {
            log.error("api person/delete error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    @ApiOperation(value="Get Person", notes="Get Person By Pin", response=ApiResultMessage.class)
    @RequestMapping(value={"/get/{pin}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getByPin(@PathVariable String pin) {
        ApiResultMessage rs = null;
        if (StringUtils.isBlank((CharSequence)pin)) {
            return ApiResultMessage.message((int)-20, (String)I18nUtil.i18nCode((String)"pers_import_pinNotEmpty", (Object[])new Object[0]));
        }
        try {
            rs = this.persApiPersonService.getApiPersonByPin(pin);
        }
        catch (Exception e) {
            log.error("api person/delete error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }
}

