/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.api.controller;

import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.api.vo.PersApiCardItem;
import com.zkteco.zkbiosecurity.pers.service.PersCardService;
import com.zkteco.zkbiosecurity.pers.service.PersParamsService;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.vo.PersCardItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/card"})
@Api(tags={"PersCard"}, description="person card")
public class PersApiCardController {
    private static final Logger log = LoggerFactory.getLogger(PersApiCardController.class);
    @Autowired
    private PersCardService persCardService;
    @Autowired
    private PersPersonService persPersonService;
    @Autowired
    private PersParamsService persParamsService;

    @ApiOperation(value="Set Card To Person", notes="Return Result Object", response=ApiResultMessage.class)
    @RequestMapping(value={"/set"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage setCardToPerson(@RequestBody PersApiCardItem card) {
        ApiResultMessage rs = ApiResultMessage.successMessage();
        try {
            String cardsSupport = this.persParamsService.getValByName("pers.cardsSupport");
            if ("false".equals(cardsSupport) && String.valueOf(1).equals(card.getCardType())) {
                return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"pers_api_cardsPersSupport", (Object[])new Object[0]));
            }
            PersPersonItem person = this.persPersonService.getItemByPin(card.getPin());
            if (person == null) {
                return ApiResultMessage.message((int)-22, (String)I18nUtil.i18nCode((String)"pers_api_personNotExist", (Object[])new Object[0]));
            }
            int ret = this.persCardService.isExitCardNo(person, card.getCardNo());
            if (ret < 0) {
                return ApiResultMessage.message((int)-23, (String)I18nUtil.i18nCode((String)"pers_person_cardDuress", (Object[])new Object[0]));
            }
            if (String.valueOf(0).equals(card.getCardType())) {
                this.persCardService.saveMasterCard(card.getPin(), card.getCardNo());
            } else if (String.valueOf(1).equals(card.getCardType())) {
                List persCardItems = this.persCardService.getItemByPersonId(person.getId());
                PersCardItem persCardItem = new PersCardItem();
                persCardItem.setPersonPin(card.getPin());
                persCardItem.setCardType(Short.valueOf(card.getCardType()));
                persCardItem.setCardNo(card.getCardNo());
                persCardItems.add(persCardItem);
                this.persCardService.saveMultiCard(persCardItems);
            }
        }
        catch (Exception e) {
            log.error("api card/set error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    @ApiOperation(value="Get Card List By Pin", notes="Return Card List", response=ApiResultMessage.class)
    @RequestMapping(value={"/getCards/{pin}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getCardsByPin(@PathVariable String pin) {
        ApiResultMessage rs = ApiResultMessage.successMessage();
        try {
            if (StringUtils.isBlank((CharSequence)pin)) {
                return ApiResultMessage.message((int)-20, (String)I18nUtil.i18nCode((String)"pers_import_pinNotEmpty", (Object[])new Object[0]));
            }
            PersPersonItem persPersonItem = this.persPersonService.getItemByPin(pin);
            if (persPersonItem == null) {
                return ApiResultMessage.message((int)-22, (String)I18nUtil.i18nCode((String)"pers_api_personNotExist", (Object[])new Object[0]));
            }
            List persCardItems = this.persCardService.getItemByPersonId(persPersonItem.getId());
            if (persCardItems != null && !persCardItems.isEmpty()) {
                ArrayList apiCardItems = Lists.newArrayList();
                persCardItems.forEach(persCardItem -> {
                    PersApiCardItem persApiCardItem = PersApiCardItem.createCard((PersCardItem)persCardItem);
                    if (persApiCardItem != null) {
                        apiCardItems.add(persApiCardItem);
                    }
                });
                rs.setData((Object)apiCardItems);
            }
        }
        catch (Exception e) {
            log.error("api card/getCards error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }
}

