/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionDetailItem;
import java.util.Date;
import java.util.List;

@From(after="POSID_TRANSACTION t")
@OrderBy(after="t.POS_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=350, winWidth=600)
public class PosIDTransactionItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.PERSON_ID")
    @GridColumn(label="posid_card_personNum", show=false)
    private String personId;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="100", i18n=true)
    private String personPin;
    @Column(name="t.PERSON_NAME")
    @GridColumn(label="pers_person_name", width="100")
    private String personName;
    @Column(name="t.PERSON_LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="80", showExpression="#language!='zh_CN'")
    private String personLastName;
    @Column(name="t.ACCOUNT_NO")
    @GridColumn(label="posid_card_accountNum", width="90")
    private String accountNo;
    @Column(name="t.TYPE_NAME")
    @GridColumn(label="posid_card_typeName", width="80", format="6=posid_common_consumption,8=posid_cus_supply,9=posid_consumerList_correction,10=posid_consumerList_theTime,11=posid_consumerList_accounting")
    private Integer typeName;
    @Column(name="t.MONEY")
    @GridColumn(label="posid_cus_money", width="100", columnType="custom", convert="convertFen2Yuan")
    private Integer money;
    @Column(name="t.BALANCE")
    @GridColumn(label="posid_account_balance", width="100", columnType="custom", convert="convertFen2Yuan")
    private Integer balance;
    @Column(name="t.MONEY_WALLET")
    @GridColumn(label="posid_account_money_wallet", show=true, columnType="custom", convert="convertFen2Yuan")
    private Integer moneyWallet;
    @Column(name="t.ALLOWANCE_WALLET")
    @GridColumn(label="posid_account_allowance_wallet", show=true, columnType="custom", convert="convertFen2Yuan")
    private Integer allowanceWallet;
    @Column(name="t.POS_MODEL", equalTag="=")
    @GridColumn(label="posid_consumerList_consumType", width="120", format="1=posid_dev_fixMode,2=posid_dev_amountMode,3=posid_dev_keyValueMode,4=posid_dev_timesMode,5=posid_dev_storeMode,6=posid_dev_timingMode,7=posid_dev_accountingMode,8=posid_leftMenu_handConsume,9=posid_device_error_correction,10=posid_dev_systemError,11=posid_dev_order,12=posid_dev_intelligence")
    private Integer posModel;
    @Column(name="t.DISCOUNT")
    @GridColumn(label="posid_iccard_discount", width="85")
    private Integer discount;
    @Column(name="t.DISCOUNT_MONEY")
    @GridColumn(label="posid_consume_discount_money", columnType="custom", convert="convertFen2Yuan")
    private Integer discountMoney;
    @Column(name="t.CONSUME_ORDER")
    @GridColumn(label="posid_consume_order", width="120", format="0=posid_system_onlyCash,1=posid_system_onlySubsidy,2=posid_system_firstCash,3=posid_system_firstSubsidy")
    private Integer consumeOrder;
    @Column(name="t.DEPT_ID")
    @GridColumn(label="posid_transaction_deptId", show=false)
    private String deptId;
    @Column(name="t.DEPT_CODE")
    @GridColumn(label="posid_card_deptNum", width="125")
    private String deptCode;
    @Column(name="t.DEPT_NAME")
    @GridColumn(label="posid_card_deptName", width="110")
    private String deptName;
    @Column(name="t.HALLING_ID")
    @GridColumn(label="posid_transaction_hallingId", show=false)
    private String hallingId;
    @Column(name="t.HALLING_CODE")
    @GridColumn(label="posid_transaction_hallingCode", show=false)
    private String hallingCode;
    @Column(name="t.HALLING_NAME")
    @GridColumn(label="posid_diningHall_name", width="110")
    private String hallingName;
    @Column(name="t.MEAL_ID", equalTag="=")
    @GridColumn(label="posid_transaction_posMeal", show=false)
    private String mealId;
    @Column(name="t.MEAL_CODE")
    @GridColumn(label="posid_meal_code", show=false)
    private String mealCode;
    @Column(name="t.MEAL_NAME")
    @GridColumn(label="posid_meal_name", width="80")
    private String mealName;
    @Column(name="t.DEV_SN")
    @GridColumn(label="common_dev_sn", width="100")
    private String devSn;
    @Column(name="t.ACCOUNT_SERIAL")
    @GridColumn(label="posid_card_cardSerial", width="130")
    private Integer accountSerial;
    @Column(name="t.CARD_NO")
    @GridColumn(label="posid_card_cardNo", width="100")
    private String cardNo;
    @Column(name="t.POS_TIME")
    @GridColumn(label="posid_cus_time", width="150")
    private Date posTime;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="posid_common_upload_time", minWidth="160", width="170")
    private Date createTime;
    @Column(name="t.CREATER_NAME")
    @GridColumn(label="posid_card_changeOperator", width="70")
    private String createrName;
    @Column(name="t.LOG_FLAG")
    @GridColumn(label="posid_card_logFlag", format="1=posid_device_upload,2=posid_system_add,3=posid_error_correction_compensation,4=posid_manual_log_flag_wechat,5=posid_manual_log_flag_alipay,6=posid_manual_log_flag_offline_consume")
    private Integer logFlag;
    @Column(name="t.IS_EXCEPTION")
    @GridColumn(label="posid_transaction_isException", show=false)
    private Boolean isException;
    @Condition(value="t.POS_TIME", equalTag=">=", toDate=true)
    private String startDatetimeBegin;
    @Condition(value="t.POS_TIME", equalTag="<=", toDate=true)
    private String startDatetimeEnd;
    @Column(name="t.DEV_ALIAS")
    @GridColumn(label="common_dev_sn", width="100", show=false)
    private String devAlias;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(t.PERSON_NAME LIKE ''%{0}%'' OR t.PERSON_LAST_NAME LIKE ''%{0}%'')")
    private String likeName;
    @Condition(value="t.DEV_SN", equalTag="=")
    private String eqlDevSn;
    @Condition(value="t.TYPE_NAME", equalTag="<>")
    private Integer typeNameNot;
    @Condition(value="t.PERSON_PIN", equalTag="=")
    private String eqlPersonPin;
    private Integer hallingType;
    private String horseManTransactionID;
    private List<PosIDTransactionDetailItem> posIDTransactionDetailItems;

    public PosIDTransactionItem() {
    }

    public PosIDTransactionItem(Boolean equals) {
        super(equals);
    }

    public PosIDTransactionItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PosIDTransactionItem(String id, String personId, String personPin, String personName, String personLastName, String deptId, String deptCode, String deptName, String hallingId, String hallingCode, String hallingName, Integer accountSerial, String cardStatus, String accountNo, String devSn, Date posTime, Date createTime, Integer money, Integer balance, Integer typeName, Integer posModel, String createrName, Integer logFlag, Integer recordType, Boolean isException, String uniqueKey) {
        this.id = id;
        this.personId = personId;
        this.personPin = personPin;
        this.personName = personName;
        this.personLastName = personLastName;
        this.deptId = deptId;
        this.deptCode = deptCode;
        this.deptName = deptName;
        this.hallingId = hallingId;
        this.hallingCode = hallingCode;
        this.hallingName = hallingName;
        this.accountSerial = accountSerial;
        this.accountNo = accountNo;
        this.devSn = devSn;
        this.posTime = posTime;
        this.createTime = createTime;
        this.money = money;
        this.balance = balance;
        this.typeName = typeName;
        this.posModel = posModel;
        this.createrName = createrName;
        this.logFlag = logFlag;
        this.isException = isException;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getAccountNo() {
        return this.accountNo;
    }

    public Integer getTypeName() {
        return this.typeName;
    }

    public Integer getMoney() {
        return this.money;
    }

    public Integer getBalance() {
        return this.balance;
    }

    public Integer getMoneyWallet() {
        return this.moneyWallet;
    }

    public Integer getAllowanceWallet() {
        return this.allowanceWallet;
    }

    public Integer getPosModel() {
        return this.posModel;
    }

    public Integer getDiscount() {
        return this.discount;
    }

    public Integer getDiscountMoney() {
        return this.discountMoney;
    }

    public Integer getConsumeOrder() {
        return this.consumeOrder;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getHallingId() {
        return this.hallingId;
    }

    public String getHallingCode() {
        return this.hallingCode;
    }

    public String getHallingName() {
        return this.hallingName;
    }

    public String getMealId() {
        return this.mealId;
    }

    public String getMealCode() {
        return this.mealCode;
    }

    public String getMealName() {
        return this.mealName;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public Integer getAccountSerial() {
        return this.accountSerial;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public Date getPosTime() {
        return this.posTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getCreaterName() {
        return this.createrName;
    }

    public Integer getLogFlag() {
        return this.logFlag;
    }

    public Boolean getIsException() {
        return this.isException;
    }

    public String getStartDatetimeBegin() {
        return this.startDatetimeBegin;
    }

    public String getStartDatetimeEnd() {
        return this.startDatetimeEnd;
    }

    public String getDevAlias() {
        return this.devAlias;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getEqlDevSn() {
        return this.eqlDevSn;
    }

    public Integer getTypeNameNot() {
        return this.typeNameNot;
    }

    public String getEqlPersonPin() {
        return this.eqlPersonPin;
    }

    public Integer getHallingType() {
        return this.hallingType;
    }

    public String getHorseManTransactionID() {
        return this.horseManTransactionID;
    }

    public List<PosIDTransactionDetailItem> getPosIDTransactionDetailItems() {
        return this.posIDTransactionDetailItems;
    }

    public PosIDTransactionItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDTransactionItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PosIDTransactionItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosIDTransactionItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosIDTransactionItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosIDTransactionItem setAccountNo(String accountNo) {
        this.accountNo = accountNo;
        return this;
    }

    public PosIDTransactionItem setTypeName(Integer typeName) {
        this.typeName = typeName;
        return this;
    }

    public PosIDTransactionItem setMoney(Integer money) {
        this.money = money;
        return this;
    }

    public PosIDTransactionItem setBalance(Integer balance) {
        this.balance = balance;
        return this;
    }

    public PosIDTransactionItem setMoneyWallet(Integer moneyWallet) {
        this.moneyWallet = moneyWallet;
        return this;
    }

    public PosIDTransactionItem setAllowanceWallet(Integer allowanceWallet) {
        this.allowanceWallet = allowanceWallet;
        return this;
    }

    public PosIDTransactionItem setPosModel(Integer posModel) {
        this.posModel = posModel;
        return this;
    }

    public PosIDTransactionItem setDiscount(Integer discount) {
        this.discount = discount;
        return this;
    }

    public PosIDTransactionItem setDiscountMoney(Integer discountMoney) {
        this.discountMoney = discountMoney;
        return this;
    }

    public PosIDTransactionItem setConsumeOrder(Integer consumeOrder) {
        this.consumeOrder = consumeOrder;
        return this;
    }

    public PosIDTransactionItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosIDTransactionItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public PosIDTransactionItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosIDTransactionItem setHallingId(String hallingId) {
        this.hallingId = hallingId;
        return this;
    }

    public PosIDTransactionItem setHallingCode(String hallingCode) {
        this.hallingCode = hallingCode;
        return this;
    }

    public PosIDTransactionItem setHallingName(String hallingName) {
        this.hallingName = hallingName;
        return this;
    }

    public PosIDTransactionItem setMealId(String mealId) {
        this.mealId = mealId;
        return this;
    }

    public PosIDTransactionItem setMealCode(String mealCode) {
        this.mealCode = mealCode;
        return this;
    }

    public PosIDTransactionItem setMealName(String mealName) {
        this.mealName = mealName;
        return this;
    }

    public PosIDTransactionItem setDevSn(String devSn) {
        this.devSn = devSn;
        return this;
    }

    public PosIDTransactionItem setAccountSerial(Integer accountSerial) {
        this.accountSerial = accountSerial;
        return this;
    }

    public PosIDTransactionItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public PosIDTransactionItem setPosTime(Date posTime) {
        this.posTime = posTime;
        return this;
    }

    public PosIDTransactionItem setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public PosIDTransactionItem setCreaterName(String createrName) {
        this.createrName = createrName;
        return this;
    }

    public PosIDTransactionItem setLogFlag(Integer logFlag) {
        this.logFlag = logFlag;
        return this;
    }

    public PosIDTransactionItem setIsException(Boolean isException) {
        this.isException = isException;
        return this;
    }

    public PosIDTransactionItem setStartDatetimeBegin(String startDatetimeBegin) {
        this.startDatetimeBegin = startDatetimeBegin;
        return this;
    }

    public PosIDTransactionItem setStartDatetimeEnd(String startDatetimeEnd) {
        this.startDatetimeEnd = startDatetimeEnd;
        return this;
    }

    public PosIDTransactionItem setDevAlias(String devAlias) {
        this.devAlias = devAlias;
        return this;
    }

    public PosIDTransactionItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDTransactionItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PosIDTransactionItem setEqlDevSn(String eqlDevSn) {
        this.eqlDevSn = eqlDevSn;
        return this;
    }

    public PosIDTransactionItem setTypeNameNot(Integer typeNameNot) {
        this.typeNameNot = typeNameNot;
        return this;
    }

    public PosIDTransactionItem setEqlPersonPin(String eqlPersonPin) {
        this.eqlPersonPin = eqlPersonPin;
        return this;
    }

    public PosIDTransactionItem setHallingType(Integer hallingType) {
        this.hallingType = hallingType;
        return this;
    }

    public PosIDTransactionItem setHorseManTransactionID(String horseManTransactionID) {
        this.horseManTransactionID = horseManTransactionID;
        return this;
    }

    public PosIDTransactionItem setPosIDTransactionDetailItems(List<PosIDTransactionDetailItem> posIDTransactionDetailItems) {
        this.posIDTransactionDetailItems = posIDTransactionDetailItems;
        return this;
    }

    public String toString() {
        return "PosIDTransactionItem(id=" + this.getId() + ", personId=" + this.getPersonId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", accountNo=" + this.getAccountNo() + ", typeName=" + this.getTypeName() + ", money=" + this.getMoney() + ", balance=" + this.getBalance() + ", moneyWallet=" + this.getMoneyWallet() + ", allowanceWallet=" + this.getAllowanceWallet() + ", posModel=" + this.getPosModel() + ", discount=" + this.getDiscount() + ", discountMoney=" + this.getDiscountMoney() + ", consumeOrder=" + this.getConsumeOrder() + ", deptId=" + this.getDeptId() + ", deptCode=" + this.getDeptCode() + ", deptName=" + this.getDeptName() + ", hallingId=" + this.getHallingId() + ", hallingCode=" + this.getHallingCode() + ", hallingName=" + this.getHallingName() + ", mealId=" + this.getMealId() + ", mealCode=" + this.getMealCode() + ", mealName=" + this.getMealName() + ", devSn=" + this.getDevSn() + ", accountSerial=" + this.getAccountSerial() + ", cardNo=" + this.getCardNo() + ", posTime=" + this.getPosTime() + ", createTime=" + this.getCreateTime() + ", createrName=" + this.getCreaterName() + ", logFlag=" + this.getLogFlag() + ", isException=" + this.getIsException() + ", startDatetimeBegin=" + this.getStartDatetimeBegin() + ", startDatetimeEnd=" + this.getStartDatetimeEnd() + ", devAlias=" + this.getDevAlias() + ", inDeptId=" + this.getInDeptId() + ", likeName=" + this.getLikeName() + ", eqlDevSn=" + this.getEqlDevSn() + ", typeNameNot=" + this.getTypeNameNot() + ", eqlPersonPin=" + this.getEqlPersonPin() + ", hallingType=" + this.getHallingType() + ", horseManTransactionID=" + this.getHorseManTransactionID() + ", posIDTransactionDetailItems=" + this.getPosIDTransactionDetailItems() + ")";
    }
}

