/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vid.controller;

import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.vid.remote.VidDebugRemote;
import com.zkteco.zkbiosecurity.vid.service.VidDebugService;
import com.zkteco.zkbiosecurity.vid.service.VidParamsService;
import com.zkteco.zkbiosecurity.vid.vo.VidDeviceItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VidDebugController
extends BaseController
implements VidDebugRemote {
    @Autowired
    private VidDebugService vidDebugService;
    @Autowired
    private VidParamsService vidParamsService;

    public ModelAndView index() {
        String loadPlugins = (String)this.vidParamsService.getVidParams().get("vid.loadPlugins");
        this.vidDebugService.isCreateSdkSession();
        this.request.setAttribute("loadPlugins", (Object)loadPlugins);
        return new ModelAndView("vid/device/setVidDebug");
    }

    public ZKResultMsg getSysInfo() {
        ZKResultMsg ret = new ZKResultMsg();
        String sysInfo = this.vidDebugService.getSysInfo();
        ret.setData((Object)sysInfo);
        return ret;
    }

    public ZKResultMsg login(VidDeviceItem item) {
        ZKResultMsg ret = this.vidDebugService.login(item);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ZKResultMsg logout(VidDeviceItem item) {
        ZKResultMsg ret = this.vidDebugService.logout(item);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ZKResultMsg getChannelCount(VidDeviceItem item) {
        short ret = this.vidDebugService.getChannelCount(item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)ret));
    }

    public ZKResultMsg capture(VidDeviceItem vidDevice) {
        ZKResultMsg ret = new ZKResultMsg();
        String result = this.vidDebugService.capture(vidDevice);
        if (null == result) {
            ret.setMsg("\u6293\u62cd\u5931\u8d25");
            ret.setRet("400");
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ZKResultMsg startRecord(VidDeviceItem vidDevice) {
        ZKResultMsg ret = new ZKResultMsg();
        byte recordType = 1;
        String filePath = this.vidDebugService.startRecord(vidDevice, recordType);
        if (StringUtils.isBlank((CharSequence)filePath)) {
            ret.setMsg("\u5f55\u50cf\u5931\u8d25");
            ret.setRet("400");
        }
        ret.setData((Object)"1");
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ZKResultMsg stopRecord(VidDeviceItem vidDevice) {
        ZKResultMsg ret = new ZKResultMsg();
        byte recordType = 1;
        boolean flag = this.vidDebugService.stopRecord(vidDevice, recordType);
        if (!flag) {
            ret.setMsg("\u505c\u6b62\u5f55\u50cf\u5931\u8d25");
            ret.setRet("400");
        }
        ret.setData((Object)"2");
        return ret;
    }

    public ZKResultMsg linkageCapture() {
        ZKResultMsg ret = new ZKResultMsg();
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ZKResultMsg linkageRecord() {
        ZKResultMsg ret = new ZKResultMsg();
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ZKResultMsg linkagePopUpVideo() {
        ZKResultMsg ret = new ZKResultMsg();
        return ret;
    }

    public ZKResultMsg getConfig(VidDeviceItem vidDevice) {
        ZKResultMsg ret = new ZKResultMsg();
        HashMap<String, Object> result = new HashMap<String, Object>();
        VidDeviceItem deviceItem = this.vidDebugService.getConfig(vidDevice);
        if (StringUtils.isBlank((CharSequence)deviceItem.getSn())) {
            ret.setRet("400");
            ret.setMsg("\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f\u5931\u8d25");
            return ret;
        }
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        short count = this.vidDebugService.getChannelCount(vidDevice);
        Integer newCount = count == 0 ? (short)1 : count;
        for (int i = 0; i < newCount; ++i) {
            SelectItem selectItem = new SelectItem();
            selectItem.setValue(String.valueOf(i));
            selectItem.setText((Object)("\u901a\u9053-" + (i + 1)));
            selectItems.add(selectItem);
        }
        result.put("config", deviceItem);
        result.put("list", selectItems);
        ret.setData(result);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ZKResultMsg getDiskNum(VidDeviceItem vidDevice) {
        int diskNum = this.vidDebugService.getDiskNum(vidDevice);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)diskNum));
    }

    public ZKResultMsg getDevTime(VidDeviceItem vidDevice) {
        String devTime = this.vidDebugService.getDevTime(vidDevice);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)devTime));
    }

    public ZKResultMsg syncDevTime(VidDeviceItem vidDevice) {
        ZKResultMsg ret = new ZKResultMsg();
        boolean flag = this.vidDebugService.syncDevTime(vidDevice);
        if (!flag) {
            ret.setRet("400");
            ret.setMsg("\u540c\u6b65\u5931\u8d25");
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public List<SelectItem> getChannelList(VidDeviceItem deviceItem) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        return selectItems;
    }
}

