/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import org.postgresql.core.ParameterList;
import org.postgresql.core.v3.CompositeParameterList;
import org.postgresql.core.v3.SimpleParameterList;
import org.postgresql.core.v3.SimpleQuery;
import org.postgresql.core.v3.V3Query;

class CompositeQuery
implements V3Query {
    private final SimpleQuery[] subqueries;
    private final int[] offsets;

    CompositeQuery(SimpleQuery[] subqueries, int[] offsets) {
        this.subqueries = subqueries;
        this.offsets = offsets;
    }

    @Override
    public ParameterList createParameterList() {
        SimpleParameterList[] subparams = new SimpleParameterList[this.subqueries.length];
        for (int i2 = 0; i2 < this.subqueries.length; ++i2) {
            subparams[i2] = (SimpleParameterList)this.subqueries[i2].createParameterList();
        }
        return new CompositeParameterList(subparams, this.offsets);
    }

    @Override
    public String toString(ParameterList parameters) {
        StringBuffer sbuf = new StringBuffer(this.subqueries[0].toString());
        for (int i2 = 1; i2 < this.subqueries.length; ++i2) {
            sbuf.append(';');
            sbuf.append(this.subqueries[i2]);
        }
        return sbuf.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public void close() {
        for (int i2 = 0; i2 < this.subqueries.length; ++i2) {
            this.subqueries[i2].close();
        }
    }

    @Override
    public SimpleQuery[] getSubqueries() {
        return this.subqueries;
    }

    @Override
    public boolean isStatementDescribed() {
        for (int i2 = 0; i2 < this.subqueries.length; ++i2) {
            if (this.subqueries[i2].isStatementDescribed()) continue;
            return false;
        }
        return true;
    }
}

