/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.BaseInputStream;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.ServerDTVImpl;
import com.microsoft.sqlserver.jdbc.TDSReader;
import java.io.IOException;
import java.util.logging.Level;

final class SimpleInputStream
extends BaseInputStream {
    private final int payloadLength;
    private byte[] bSingleByte;

    SimpleInputStream(TDSReader tDSReader, int n2, InputStreamGetterArgs inputStreamGetterArgs, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        super(tDSReader, inputStreamGetterArgs.isAdaptive, inputStreamGetterArgs.isStreaming, serverDTVImpl);
        this.setLoggingInfo(inputStreamGetterArgs.logContext);
        this.payloadLength = n2;
    }

    @Override
    public void close() throws IOException {
        if (null == this.tdsReader) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + "Enter Closing SimpleInputStream.");
        }
        this.skip(this.payloadLength - this.streamPos);
        this.closeHelper();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + "Exit Closing SimpleInputStream.");
        }
    }

    private final boolean isEOS() throws IOException {
        assert (this.streamPos <= this.payloadLength);
        return this.streamPos == this.payloadLength;
    }

    @Override
    public long skip(long l2) throws IOException {
        this.checkClosed();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + " Skipping :" + l2);
        }
        if (l2 < 0L) {
            return 0L;
        }
        if (this.isEOS()) {
            return 0L;
        }
        int n2 = (long)this.streamPos + l2 > (long)this.payloadLength ? this.payloadLength - this.streamPos : (int)l2;
        try {
            this.tdsReader.skip(n2);
        }
        catch (SQLServerException sQLServerException) {
            throw new IOException(sQLServerException.getMessage());
        }
        this.streamPos += n2;
        if (this.isReadLimitSet && this.streamPos - this.markedStreamPos > this.readLimit) {
            this.clearCurrentMark();
        }
        return n2;
    }

    @Override
    public int available() throws IOException {
        this.checkClosed();
        assert (this.streamPos <= this.payloadLength);
        int n2 = this.payloadLength - this.streamPos;
        if (this.tdsReader.available() < n2) {
            n2 = this.tdsReader.available();
        }
        return n2;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (null == this.bSingleByte) {
            this.bSingleByte = new byte[1];
        }
        if (this.isEOS()) {
            return -1;
        }
        int n2 = this.read(this.bSingleByte, 0, 1);
        return 0 == n2 ? -1 : this.bSingleByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        this.checkClosed();
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.checkClosed();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + " Reading " + n3 + " from stream offset " + this.streamPos + " payload length " + this.payloadLength);
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (0 == n3) {
            return 0;
        }
        if (this.isEOS()) {
            return -1;
        }
        int n4 = 0;
        n4 = this.streamPos + n3 > this.payloadLength ? this.payloadLength - this.streamPos : n3;
        try {
            this.tdsReader.readBytes(byArray, n2, n4);
        }
        catch (SQLServerException sQLServerException) {
            throw new IOException(sQLServerException.getMessage());
        }
        this.streamPos += n4;
        if (this.isReadLimitSet && this.streamPos - this.markedStreamPos > this.readLimit) {
            this.clearCurrentMark();
        }
        return n4;
    }

    @Override
    public void mark(int n2) {
        if (null != this.tdsReader && n2 > 0) {
            this.currentMark = this.tdsReader.mark();
            this.markedStreamPos = this.streamPos;
            this.setReadLimit(n2);
        }
    }

    @Override
    public void reset() throws IOException {
        this.resetHelper();
        this.streamPos = this.markedStreamPos;
    }

    @Override
    final byte[] getBytes() throws SQLServerException {
        assert (0 == this.streamPos);
        byte[] byArray = new byte[this.payloadLength];
        try {
            this.read(byArray);
            this.close();
        }
        catch (IOException iOException) {
            SQLServerException.makeFromDriverError(null, null, iOException.getMessage(), null, true);
        }
        return byArray;
    }
}

