/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SQLServerResultSetMetaData
implements ResultSetMetaData {
    private SQLServerConnection con;
    private final SQLServerResultSet rs;
    public int nBeforeExecuteCols;
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerResultSetMetaData");
    private static int baseID = 0;
    private final String traceID = " SQLServerResultSetMetaData:" + SQLServerResultSetMetaData.nextInstanceID();

    private static synchronized int nextInstanceID() {
        return ++baseID;
    }

    public final String toString() {
        return this.traceID;
    }

    SQLServerResultSetMetaData(SQLServerConnection sQLServerConnection, SQLServerResultSet sQLServerResultSet) {
        this.con = sQLServerConnection;
        this.rs = sQLServerResultSet;
        assert (sQLServerResultSet != null);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toString() + " created by (" + sQLServerResultSet.toString() + ")");
        }
    }

    private void checkClosed() throws SQLServerException {
        this.rs.checkClosed();
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public String getCatalogName(int n2) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n2).getTableName().getDatabaseName();
    }

    @Override
    public int getColumnCount() throws SQLServerException {
        this.checkClosed();
        if (this.rs == null) {
            return 0;
        }
        return this.rs.getColumnCount();
    }

    @Override
    public int getColumnDisplaySize(int n2) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n2).getTypeInfo().getDisplaySize();
    }

    @Override
    public String getColumnLabel(int n2) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n2).getColumnName();
    }

    @Override
    public String getColumnName(int n2) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n2).getColumnName();
    }

    @Override
    public int getColumnType(int n2) throws SQLServerException {
        this.checkClosed();
        TypeInfo typeInfo = this.rs.getColumn(n2).getTypeInfo();
        JDBCType jDBCType = typeInfo.getSSType().getJDBCType();
        int n3 = jDBCType.asJavaSqlType();
        if (this.con.isKatmaiOrLater()) {
            SSType sSType = typeInfo.getSSType();
            switch (sSType) {
                case VARCHARMAX: {
                    n3 = SSType.VARCHAR.getJDBCType().asJavaSqlType();
                    break;
                }
                case NVARCHARMAX: {
                    n3 = SSType.NVARCHAR.getJDBCType().asJavaSqlType();
                    break;
                }
                case VARBINARYMAX: {
                    n3 = SSType.VARBINARY.getJDBCType().asJavaSqlType();
                }
            }
        }
        return n3;
    }

    @Override
    public String getColumnTypeName(int n2) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n2).getTypeInfo().getSSTypeName();
    }

    @Override
    public int getPrecision(int n2) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n2).getTypeInfo().getPrecision();
    }

    @Override
    public int getScale(int n2) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n2).getTypeInfo().getScale();
    }

    @Override
    public String getSchemaName(int n2) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n2).getTableName().getSchemaName();
    }

    @Override
    public String getTableName(int n2) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n2).getTableName().getObjectName();
    }

    @Override
    public boolean isAutoIncrement(int n2) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n2).getTypeInfo().isIdentity();
    }

    @Override
    public boolean isCaseSensitive(int n2) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n2).getTypeInfo().isCaseSensitive();
    }

    @Override
    public boolean isCurrency(int n2) throws SQLServerException {
        this.checkClosed();
        SSType sSType = this.rs.getColumn(n2).getTypeInfo().getSSType();
        return SSType.MONEY == sSType || SSType.SMALLMONEY == sSType;
    }

    @Override
    public boolean isDefinitelyWritable(int n2) throws SQLServerException {
        this.checkClosed();
        return TypeInfo.UPDATABLE_READ_WRITE == this.rs.getColumn(n2).getTypeInfo().getUpdatability();
    }

    @Override
    public int isNullable(int n2) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n2).getTypeInfo().isNullable() ? 1 : 0;
    }

    @Override
    public boolean isReadOnly(int n2) throws SQLServerException {
        this.checkClosed();
        return TypeInfo.UPDATABLE_READ_ONLY == this.rs.getColumn(n2).getTypeInfo().getUpdatability();
    }

    @Override
    public boolean isSearchable(int n2) throws SQLServerException {
        this.checkClosed();
        switch (this.rs.getColumn(n2).getTypeInfo().getSSType()) {
            case IMAGE: 
            case TEXT: 
            case NTEXT: 
            case UDT: 
            case XML: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSigned(int n2) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n2).getTypeInfo().getSSType().getJDBCType().isSigned();
    }

    @Override
    public boolean isWritable(int n2) throws SQLServerException {
        this.checkClosed();
        int n3 = this.rs.getColumn(n2).getTypeInfo().getUpdatability();
        return TypeInfo.UPDATABLE_READ_WRITE == n3 || TypeInfo.UPDATABLE_UNKNOWN == n3;
    }

    @Override
    public String getColumnClassName(int n2) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n2).getTypeInfo().getSSType().getJDBCType().className();
    }
}

