/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerClobBase;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;

final class SQLServerClobWriter
extends Writer {
    private SQLServerClobBase parentClob = null;
    private long streamPos;

    SQLServerClobWriter(SQLServerClobBase sQLServerClobBase, long l2) {
        this.parentClob = sQLServerClobBase;
        this.streamPos = l2;
    }

    @Override
    public void write(char[] cArray) throws IOException {
        if (null == cArray) {
            return;
        }
        this.write(new String(cArray));
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        if (null == cArray) {
            return;
        }
        this.write(new String(cArray, n2, n3));
    }

    @Override
    public void write(int n2) throws IOException {
        char[] cArray = new char[]{(char)n2};
        this.write(new String(cArray));
    }

    @Override
    public void write(String string, int n2, int n3) throws IOException {
        this.checkClosed();
        try {
            int n4 = this.parentClob.setString(this.streamPos, string, n2, n3);
            this.streamPos += (long)n4;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    @Override
    public void write(String string) throws IOException {
        if (null == string) {
            return;
        }
        this.write(string, 0, string.length());
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
    }

    @Override
    public void close() throws IOException {
        this.checkClosed();
        this.parentClob = null;
    }

    private void checkClosed() throws IOException {
        if (null == this.parentClob) {
            throw new IOException(SQLServerException.getErrString("R_streamIsClosed"));
        }
    }
}

