/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.distributor.push.processor;

import com.alibaba.fastjson.JSON;
import com.zkteco.zkbiosecurity.adms.cache.AdmsCacheManager;
import com.zkteco.zkbiosecurity.adms.distributor.push.processor.BaseProcessor;
import com.zkteco.zkbiosecurity.adms.distributor.utils.JSONObjectUtil;
import com.zkteco.zkbiosecurity.adms.distributor.utils.RequestUtil;
import com.zkteco.zkbiosecurity.adms.service.AdmsAuthDeviceService;
import com.zkteco.zkbiosecurity.adms.service.AdmsDevCmdService;
import com.zkteco.zkbiosecurity.adms.service.AdmsDeviceOptionService;
import com.zkteco.zkbiosecurity.adms.service.AdmsDeviceService;
import com.zkteco.zkbiosecurity.adms.vo.AdmsAuthDeviceItem;
import com.zkteco.zkbiosecurity.adms.vo.AdmsPosReqParamItem;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PosPushProcessor
extends BaseProcessor {
    @Autowired
    private AdmsDeviceService admsDeviceService;
    @Autowired
    private AdmsDeviceOptionService admsDeviceOptionService;
    @Autowired
    private AdmsAuthDeviceService admsAuthDeviceService;
    @Autowired
    private AdmsDevCmdService admsDevCmdService;
    @Autowired
    private AdmsCacheManager admsCacheManager;

    @Override
    public String handleReqData(ChannelHandlerContext ctx, HttpRequest httpRequest, String sn) throws Exception {
        String uri = httpRequest.getUri();
        URI uriObj = new URI(uri);
        String requestPath = uriObj.getPath();
        this.printLog(sn, uri);
        boolean firstReq = uri.contains("options") && uri.contains("pushver") && uri.contains("language");
        String rs = "UNKNOWN DEVICE";
        if (firstReq) {
            AdmsPosReqParamItem admsPosReqParamItem = new AdmsPosReqParamItem(sn, this.getClientIP(ctx, httpRequest), Integer.valueOf(this.getServerPort(httpRequest)), RequestUtil.getParams(uri, "language"), RequestUtil.getParams(uri, "pushver"), RequestUtil.getParams(uri, "devicename"), RequestUtil.getParams(uri, "fireVer"), RequestUtil.getParams(uri, "char_code"), RequestUtil.getParams(uri, "IsConsumeFunType"));
            rs = this.dealFirstReq(admsPosReqParamItem);
        } else {
            String encoding = this.admsDeviceService.getPosCharCode(sn);
            String data = "";
            switch (requestPath) {
                case "/iclock/cpos": {
                    String table = RequestUtil.getParams(uri, "table");
                    String stampId = RequestUtil.getParams(uri, "StampId");
                    String type = RequestUtil.getParams(uri, "type");
                    if (StringUtils.isNotBlank((CharSequence)table)) {
                        data = this.getContentData(httpRequest, "83".equals(encoding) ? "GB2312" : "UTF-8");
                        if (!StringUtils.isNotBlank((CharSequence)data)) break;
                        rs = this.cposData(sn, table, stampId, httpRequest, encoding);
                        break;
                    }
                    if (!"time".equals(type)) break;
                    rs = this.getSyncTime(sn);
                    break;
                }
                case "/iclock/posrequest": {
                    rs = this.getRequest(sn, uri);
                    break;
                }
                case "/iclock/posdevicecmd": {
                    data = this.getContentData(httpRequest, "UTF-8");
                    rs = this.admsDevCmdService.devReturnCmd(sn, data);
                    break;
                }
            }
        }
        return rs;
    }

    private String getSyncTime(String sn) {
        String date = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        return "Time=" + date;
    }

    private String cposData(String sn, String table, String stamp, HttpRequest httpRequest, String encoding) {
        String flag = table.toLowerCase();
        String data = this.getContentData(httpRequest, "83".equals(encoding) ? "GB2312" : "UTF-8");
        if (StringUtils.isNotBlank((CharSequence)data)) {
            this.admsCacheManager.cachePosLog(sn, flag, data);
        }
        switch (table) {
            case "BUYLOG": {
                this.admsDeviceOptionService.updateDevOptionVal(sn, "PosLogStampId", stamp);
                break;
            }
            case "BUYLOGBAK": {
                this.admsDeviceOptionService.updateDevOptionVal(sn, "PosBakLogStampId", stamp);
                break;
            }
            case "FULLLOG": {
                this.admsDeviceOptionService.updateDevOptionVal(sn, "FullLogStampId", stamp);
                break;
            }
            case "FULLLOGBAK": {
                this.admsDeviceOptionService.updateDevOptionVal(sn, "FullBakLogStampId", stamp);
                break;
            }
            case "ALLOWLOG": {
                this.admsDeviceOptionService.updateDevOptionVal(sn, "AllowLogStampId", stamp);
                break;
            }
            case "ALLOWLOGBAK": {
                this.admsDeviceOptionService.updateDevOptionVal(sn, "AllowBakLogStampId", stamp);
                break;
            }
            case "keydetail": {
                break;
            }
        }
        return "OK";
    }

    private String getRequest(String sn, String uri) {
        String rs = "OK";
        this.admsDeviceService.updateDevOperateState(sn, "GET_RT_LOG", "0");
        String cmd = this.admsDeviceService.getCmd(sn, 10);
        if (StringUtils.isNotBlank((CharSequence)cmd)) {
            rs = cmd;
        }
        return rs;
    }

    private String dealFirstReq(AdmsPosReqParamItem admsPosReqParamItem) {
        AdmsAuthDeviceItem authInfo = this.admsAuthDeviceService.getAuthDeviceInfo(admsPosReqParamItem.getSn());
        String retInfo = "";
        if (authInfo != null && authInfo.getAuthFlag() != null && authInfo.getAuthFlag().booleanValue()) {
            Map<String, String> deviceOptions = this.createPosDeviceOpt(admsPosReqParamItem);
            retInfo = this.admsDeviceService.regPosDevice(admsPosReqParamItem.getSn(), deviceOptions);
            if (StringUtils.isNotBlank((CharSequence)admsPosReqParamItem.getIp()) && !admsPosReqParamItem.getIp().equals(authInfo.getIp())) {
                authInfo.setIp(admsPosReqParamItem.getIp());
                this.admsAuthDeviceService.setAuthDeviceInfo(authInfo);
            }
        } else {
            this.log.info("pos device sn=" + admsPosReqParamItem.getSn() + " no auth ,request reject");
            if (authInfo == null) {
                String ipAddress = admsPosReqParamItem.getIp();
                String netMask = "";
                String gateway = "";
                String mac = "";
                String deviceType = "pos";
                String server = "";
                AdmsAuthDeviceItem item = new AdmsAuthDeviceItem(ipAddress, mac, netMask, gateway, admsPosReqParamItem.getSn(), deviceType, server, admsPosReqParamItem.getDeviceName());
                this.admsAuthDeviceService.setAuthDeviceInfo(item);
            }
            retInfo = "UNKNOWN DEVICE";
        }
        return retInfo;
    }

    private Map<String, String> createPosDeviceOpt(AdmsPosReqParamItem admsPosReqParamItem) {
        String devInfo = this.admsCacheManager.getDeviceInfo(admsPosReqParamItem.getSn());
        Map<String, String> optionsJson = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)devInfo)) {
            optionsJson.put("SN", admsPosReqParamItem.getSn());
            optionsJson.put("Stamp", "0");
            optionsJson.put("OpStamp", "0");
            optionsJson.put("PosLogStamp", "0");
            optionsJson.put("FullLogStamp", "0");
            optionsJson.put("AllowLogStamp", "0");
            optionsJson.put("FullLogStampId", "0");
            optionsJson.put("AllowLogStampId", "0");
            optionsJson.put("PosLogStampId", "0");
            optionsJson.put("PosBakLogStampId", "0");
            optionsJson.put("FullBakLogStampId", "0");
            optionsJson.put("AllowBakLogStampId", "0");
            optionsJson.put("UseStampId", "1");
            optionsJson.put("TableNameStamp", "0");
            optionsJson.put("ErrorDelay", "1");
            optionsJson.put("Delay", "10");
            optionsJson.put("TransTimes", "NONE");
            optionsJson.put("TransInterval", "1");
            optionsJson.put("Realtime", "1");
            optionsJson.put("Encrypt", "NONE");
            optionsJson.put("SyncTime", "10");
            optionsJson.put("UseSection", "1");
            optionsJson.put("BackSection", "2");
            optionsJson.put("DeviceType", "pos");
            optionsJson.put("language", admsPosReqParamItem.getLanguage());
            optionsJson.put("~DeviceName", admsPosReqParamItem.getDeviceName());
            optionsJson.put("CommType", "3");
            optionsJson.put("IPAddress", admsPosReqParamItem.getIp());
            optionsJson.put("IpPort", admsPosReqParamItem.getPort() + "");
            optionsJson.put("ServerVer", "AdmsPro-v1.0");
            optionsJson.put("fireVer", admsPosReqParamItem.getFireVer());
            optionsJson.put("pushVer", admsPosReqParamItem.getPushVer());
            optionsJson.put("charCode", admsPosReqParamItem.getCharCode());
            optionsJson.put("enalbed", "true");
            optionsJson.put("IsConsumeFunType", admsPosReqParamItem.getConsumeFunType());
        } else {
            optionsJson = (Map)JSON.parseObject((String)devInfo, Map.class);
            if (StringUtils.isNotBlank((CharSequence)admsPosReqParamItem.getIp()) && !admsPosReqParamItem.getIp().equals(optionsJson.get("IPAddress"))) {
                optionsJson.put("IPAddress", admsPosReqParamItem.getIp());
                JSONObject json = JSONObjectUtil.createJson(devInfo);
                JSONObjectUtil.setKeyValue(json, "IPAddress", admsPosReqParamItem.getIp());
                this.admsCacheManager.cacheDeviceInfo(admsPosReqParamItem.getSn(), json.toString());
            }
        }
        return optionsJson;
    }
}

