/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.distributor.push.processor;

import com.zkteco.zkbiosecurity.adms.bean.Adms2AttDevUploadInfo;
import com.zkteco.zkbiosecurity.adms.cache.AdmsCacheManager;
import com.zkteco.zkbiosecurity.adms.distributor.push.processor.BaseProcessor;
import com.zkteco.zkbiosecurity.adms.distributor.utils.DeviceDataUtil;
import com.zkteco.zkbiosecurity.adms.distributor.utils.JSONObjectUtil;
import com.zkteco.zkbiosecurity.adms.distributor.utils.RequestUtil;
import com.zkteco.zkbiosecurity.adms.service.Adms4AttService;
import com.zkteco.zkbiosecurity.adms.service.AdmsAuthDeviceService;
import com.zkteco.zkbiosecurity.adms.service.AdmsDevCmdService;
import com.zkteco.zkbiosecurity.adms.service.AdmsDeviceService;
import com.zkteco.zkbiosecurity.adms.vo.AdmsAuthDeviceItem;
import com.zkteco.zkbiosecurity.adms.vo.AdmsDevCmdItem;
import com.zkteco.zkbiosecurity.base.utils.Base64Util;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;

@Component
public class AttPushProcessor
extends BaseProcessor {
    @Autowired
    private AdmsDeviceService admsDeviceService;
    @Autowired
    private AdmsAuthDeviceService admsAuthDeviceService;
    @Autowired(required=false)
    private Adms4AttService adms4AttService;
    @Autowired
    private AdmsDevCmdService admsDevCmdService;
    @Autowired
    private AdmsCacheManager admsCacheManager;

    @Override
    public String handleReqData(ChannelHandlerContext ctx, HttpRequest httpRequest, String sn) throws Exception {
        boolean exist;
        String uri = httpRequest.getUri();
        URI uriObj = new URI(uri);
        String requestPath = uriObj.getPath();
        String clientIP = this.getClientIP(ctx, httpRequest);
        this.printLog(sn, uri);
        boolean firstReq = uri.contains("options") && uri.contains("pushver") && uri.contains("language");
        String rs = "UNKNOWN DEVICE";
        if (firstReq) {
            String language = RequestUtil.getParams(uri, "language");
            int serverPort = this.getServerPort(httpRequest);
            String serverHost = this.getServerHostAddr(httpRequest);
            String pushOptionsFlag = RequestUtil.getParams(uri, "PushOptionsFlag");
            String pushver = RequestUtil.getParams(uri, "pushver");
            rs = this.dealFirstReq(sn, pushver, language, clientIP, serverPort, pushOptionsFlag, serverHost);
        } else if (this.admsDeviceService.isAuthIp(clientIP) && (exist = this.admsDeviceService.existDevice(sn))) {
            String encoding = this.getEncoding(sn);
            switch (requestPath) {
                case "/iclock/ping": {
                    rs = "OK";
                    break;
                }
                case "/iclock/cdata": {
                    String table = RequestUtil.getParams(uri, "table");
                    String stamp = RequestUtil.getParams(uri, "Stamp");
                    rs = this.attCdataUpload(sn, table, stamp, httpRequest, encoding, uri);
                    break;
                }
                case "/iclock/getrequest": {
                    rs = this.getRequest(sn, uri);
                    break;
                }
                case "/iclock/devicecmd": {
                    String data = this.getContentData(httpRequest, encoding);
                    rs = this.deviceCmd(sn, data);
                    break;
                }
                case "/iclock/file": {
                    String url = RequestUtil.getParams(uri, "url");
                    String datacode = RequestUtil.getParams(uri, "datacode");
                    if (url == null) break;
                    rs = this.downFile(datacode, url);
                    break;
                }
            }
        }
        return rs;
    }

    private String getRequest(String sn, String uri) {
        String info;
        String rs = "OK";
        this.admsDeviceService.updateDevOperateState(sn, "GET_RT_LOG", "0");
        String cmd = this.admsDeviceService.getCmd(sn, 10);
        if (StringUtils.isNotBlank((CharSequence)cmd)) {
            rs = cmd;
        }
        if (StringUtils.isNotBlank((CharSequence)(info = RequestUtil.getParams(uri, "INFO")))) {
            this.attUploadInfo(sn, info);
        }
        return rs;
    }

    private void attUploadInfo(String sn, String info) {
        String[] devInfoArray = info.split(",");
        Adms2AttDevUploadInfo devUploadInfo = new Adms2AttDevUploadInfo();
        devUploadInfo.setSn(sn);
        devUploadInfo.setFwVersion(devInfoArray[0]);
        devUploadInfo.setUsercCount(Integer.valueOf(devInfoArray[1]));
        devUploadInfo.setFpCount(Integer.valueOf(devInfoArray[2]));
        devUploadInfo.setTransactionCount(Integer.valueOf(devInfoArray[3]));
        devUploadInfo.setIpAddress(devInfoArray[4]);
        devUploadInfo.setFpVersion(devInfoArray[5]);
        devUploadInfo.setFaceVersion(devInfoArray[6]);
        devUploadInfo.setFaceCount(Integer.valueOf(devInfoArray[8]));
        devUploadInfo.setAttSupportFunList(devInfoArray[9]);
        if (this.adms4AttService != null) {
            this.adms4AttService.uploadDevInfo(devUploadInfo);
        }
        this.admsDeviceService.updateAttLoadInfo(devUploadInfo);
    }

    private String deviceCmd(String sn, String data) {
        return this.admsDevCmdService.devReturnCmd(sn, data);
    }

    public String dealFirstReq(String sn, String pushver, String language, String ip, int port, String pushOptionsFlag, String serverHost) {
        this.log.info("att device options request.....sn=" + sn);
        AdmsAuthDeviceItem authInfo = this.admsAuthDeviceService.getAuthDeviceInfo(sn);
        String retInfo = "UNKNOWN DEVICE";
        this.admsDeviceService.setDevEncoding("att", sn, language);
        if (authInfo != null && authInfo.getAuthFlag() != null && authInfo.getAuthFlag().booleanValue()) {
            Map deviceOptions = this.admsDeviceService.createAttDeviceOpt(sn, pushver, language, ip, port, pushOptionsFlag, serverHost);
            retInfo = this.admsDeviceService.regAttDevice(sn, deviceOptions);
        } else {
            this.log.info("att device sn=" + sn + " no auth ,request reject");
            if (authInfo == null || !authInfo.getIp().equals(ip) || !"att".equals(authInfo.getDeviceType())) {
                String ipAddress = ip;
                String netMask = "";
                String gateway = "";
                String mac = "";
                String deviceType = "att";
                String deviceName = "";
                String server = "";
                AdmsAuthDeviceItem item = new AdmsAuthDeviceItem(ipAddress, mac, netMask, gateway, sn, deviceType, server, deviceName);
                this.admsAuthDeviceService.setAuthDeviceInfo(item);
            }
        }
        return retInfo;
    }

    private String getAttDevOptionInfo(JSONObject optionsJson) {
        StringBuffer devOptions = new StringBuffer();
        devOptions.append("GET OPTION FROM: " + JSONObjectUtil.getStrValueByKey(optionsJson, "SN"));
        devOptions.append("\nATTLOGStamp=" + JSONObjectUtil.getStrValueByKey(optionsJson, "ATTLOGStamp"));
        devOptions.append("\nOPERLOGStamp=" + JSONObjectUtil.getStrValueByKey(optionsJson, "OPERLOGStamp"));
        devOptions.append("\nBIODATAStamp=" + JSONObjectUtil.getStrValueByKey(optionsJson, "BIODATAStamp"));
        devOptions.append("\nATTPHOTOStamp=" + JSONObjectUtil.getStrValueByKey(optionsJson, "ATTPHOTOStamp"));
        devOptions.append("\nErrorDelay=" + JSONObjectUtil.getStrValueByKey(optionsJson, "ErrorDelay"));
        devOptions.append("\nDelay=" + JSONObjectUtil.getStrValueByKey(optionsJson, "Delay"));
        devOptions.append("\nTransTimes=" + JSONObjectUtil.getStrValueByKey(optionsJson, "TransTimes"));
        devOptions.append("\nTransInterval=" + JSONObjectUtil.getStrValueByKey(optionsJson, "TransInterval"));
        devOptions.append("\nTransFlag=" + JSONObjectUtil.getStrValueByKey(optionsJson, "TransFlag"));
        devOptions.append("\nTimeZone=" + JSONObjectUtil.getStrValueByKey(optionsJson, "TimeZone"));
        devOptions.append("\nRealtime=" + JSONObjectUtil.getStrValueByKey(optionsJson, "Realtime"));
        devOptions.append("\nEncrypt=" + JSONObjectUtil.getStrValueByKey(optionsJson, "Encrypt"));
        devOptions.append("\nServerVer=" + JSONObjectUtil.getStrValueByKey(optionsJson, "ServerVer"));
        if (optionsJson.has("PushOptionsFlag") && "1".equals(JSONObjectUtil.getStrValueByKey(optionsJson, "PushOptionsFlag"))) {
            devOptions.append("\nPushOptions=RegDeviceType,FingerFunOn,FaceFunOn,FPVersion,FaceVersion,BioPhotoFun,BioDataFun");
        }
        devOptions.append("\n");
        this.log.info("att device get options=" + devOptions.toString());
        return devOptions.toString();
    }

    public boolean registryAtt(String sn, String data) {
        return false;
    }

    public String attCdataUpload(String sn, String table, String stamp, HttpRequest request, String encoding, String uri) {
        String flag = "OK";
        String data = "";
        if ("options".equals(table)) {
            data = this.getContentData(request, encoding);
            this.log.info("optons data=" + data);
            String[] cmdReturnLine = data.trim().split(",");
            Map<String, String> devOptions = DeviceDataUtil.getAttOptions(cmdReturnLine);
            devOptions.put("SN", sn);
            this.adms4AttService.updateDeviceOptions(devOptions);
        } else if ("ATTLOG".equals(table)) {
            data = this.getContentData(request, encoding);
            this.log.info("ATTLOG data=" + data);
            this.admsDeviceService.saveAttLog(sn, data, stamp);
        } else if ("ATTPHOTO".equals(table)) {
            data = this.getAttPhotoDataInfo((HttpContent)request);
            if (StringUtils.isNotBlank((CharSequence)data)) {
                this.admsDeviceService.saveAttPhoto(sn, data, stamp);
            }
        } else if ("OPERLOG".equals(table)) {
            data = this.getContentData(request, encoding);
            if (data.startsWith("USER") || data.startsWith("FP") || data.startsWith("FACE") || data.startsWith("USERPIC") || data.startsWith("BIOPHOTO")) {
                this.log.info("att device OPERLOG data=" + data.substring(0, data.length() < 50 ? data.length() : 50));
                this.admsDeviceService.setAttOperLog(sn, data, stamp);
            } else if (data.startsWith("OPLOG")) {
                this.log.info("att device oplog=" + data);
                this.admsDeviceService.setAttOpLog(sn, data, stamp);
            }
        } else if ("BIODATA".equals(table)) {
            data = this.getContentData(request, encoding);
            if (StringUtils.isNotBlank((CharSequence)data)) {
                this.admsDeviceService.setBioData(sn, data, stamp);
            } else {
                flag = "UNKNOWN DEVICE";
            }
        } else if ("RemoteAtt".equals(table)) {
            String pin = RequestUtil.getParams(uri, "PIN");
            flag = this.admsDeviceService.remoteAtt(sn, pin);
        } else if ("ERRORLOG".equals(table)) {
            data = this.getContentData(request, encoding);
            flag = this.dealErrorLog(sn, data);
        }
        return flag;
    }

    private String dealErrorLog(String sn, String data) {
        String flag = "OK";
        String[] dataArray = data.split("\r\n");
        HashSet<Long> cmdIds = new HashSet<Long>();
        HashMap<Long, String> remarkMap = new HashMap<Long, String>();
        for (String tempData : dataArray) {
            tempData = tempData.split(" ")[1];
            Map<String, String> dataMap = DeviceDataUtil.formateStrToMap(tempData, "\t");
            Long cmdId = Long.parseLong(dataMap.get("CmdId"));
            cmdIds.add(cmdId);
            byte[] decode = Base64Util.decode((String)dataMap.get("Additional"));
            JSONObject additional = JSONObjectUtil.createJson(new String(decode));
            String remark = "ErrCode:" + dataMap.get("ErrCode") + ",ErrMsg:" + dataMap.get("ErrMsg") + ",Additional:" + additional + ";";
            if (remarkMap.containsKey(cmdId)) {
                remarkMap.put(cmdId, (String)remarkMap.get(cmdId) + remark);
                continue;
            }
            remarkMap.put(cmdId, remark);
        }
        Map admsDevCmdItems = this.admsDevCmdService.getItemListByCmdIds(cmdIds);
        if (admsDevCmdItems != null && admsDevCmdItems.size() > 0) {
            for (Map.Entry entry : admsDevCmdItems.entrySet()) {
                AdmsDevCmdItem admsDevCmdItem;
                admsDevCmdItem.setRemark(StringUtils.isNotBlank((CharSequence)(admsDevCmdItem = (AdmsDevCmdItem)entry.getValue()).getRemark()) ? admsDevCmdItem.getRemark() : "" + (String)remarkMap.get(entry.getKey()));
                this.admsDevCmdService.saveItem(admsDevCmdItem);
            }
        }
        return flag;
    }

    private String getAttPhotoDataInfo(HttpContent request) {
        HttpContent httpContent = request;
        ByteBuf contentByteBuf = httpContent.content();
        contentByteBuf.readableBytes();
        int bufLen = contentByteBuf.readableBytes();
        byte[] bufArray = new byte[bufLen];
        contentByteBuf.readBytes(bufArray);
        String data = new String(bufArray);
        if (StringUtils.isNotBlank((CharSequence)data)) {
            String[] headArray = data.split("CMD=uploadphoto", 2);
            JSONObject jsonData = new JSONObject();
            Map<String, String> preInfoMap = DeviceDataUtil.formateStrToMap(headArray[0], "\n");
            for (String key : preInfoMap.keySet()) {
                JSONObjectUtil.setKeyValue(jsonData, key, preInfoMap.get(key));
            }
            int photoBufLength = Integer.parseInt(preInfoMap.get("size"));
            byte[] fileDataBytesBase64 = Base64.encodeBase64((byte[])ArrayUtils.subarray((byte[])bufArray, (int)(bufLen - photoBufLength), (int)(bufLen - 1)));
            String fileDataStrBase64 = new String(fileDataBytesBase64);
            JSONObjectUtil.setKeyValue(jsonData, "photo", fileDataStrBase64);
            return jsonData.toString();
        }
        this.log.error("AttPushProcessor GetAttPhotoDataInfo Error : photo data is null!");
        return null;
    }

    private String downFile(String datacode, String fileUrl) {
        boolean isB64Code = true;
        if (StringUtils.isNotBlank((CharSequence)datacode) && "original".equals(datacode)) {
            isB64Code = false;
        }
        String rs = "";
        URL url = null;
        HttpURLConnection httpUrl = null;
        InputStream is = null;
        ByteArrayOutputStream outStream = null;
        try {
            fileUrl = fileUrl.replace("*", ":").replace("\\", "/");
            if (fileUrl.contains("localhost")) {
                fileUrl = fileUrl.substring(fileUrl.indexOf("upload"));
                File file = new File(FileUtil.getLocalFullPath((String)fileUrl));
                is = new FileInputStream(file);
            } else {
                url = new URL(fileUrl);
                httpUrl = (HttpURLConnection)url.openConnection();
                httpUrl.connect();
                is = httpUrl.getInputStream();
            }
            outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = is.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            rs = isB64Code ? Base64Utils.encodeToString((byte[])outStream.toByteArray()) : new String(outStream.toByteArray());
        }
        catch (IOException e) {
            this.log.error("upgradeFirmware error", (Throwable)e);
            throw new ZKBusinessException("upgradeFirmware error");
        }
        finally {
            try {
                if (Objects.nonNull(is)) {
                    is.close();
                }
                if (Objects.nonNull(outStream)) {
                    outStream.close();
                }
                if (Objects.nonNull(httpUrl)) {
                    httpUrl.disconnect();
                }
            }
            catch (IOException e) {
                this.log.error("upgradeFirmware error", (Throwable)e);
            }
        }
        return rs;
    }

    public String getEncoding(String sn) {
        return this.admsDeviceService.getDevEncoding(sn);
    }
}

