/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.distributor.push;

import com.zkteco.zkbiosecurity.adms.distributor.utils.DeviceDataUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
@Order(value=134)
public class PushResponse {
    private static int port;
    private static String ishttps;
    private static RestTemplate restTemplate;
    private static Logger log;
    private static final SimpleDateFormat sdf;
    private static final Calendar cd;

    @Value(value="${security.require-ssl:false}")
    public void setIshttps(String ishttps) {
        PushResponse.ishttps = ishttps;
    }

    @Value(value="${server.port:8098}")
    public void setPort(int port) {
        PushResponse.port = port;
    }

    @Autowired
    public void setRestTemplate(RestTemplate restTemplate) {
        PushResponse.restTemplate = restTemplate;
    }

    public static boolean response(Channel channel, String responseContent, boolean keepAlive, String encoding) throws UnsupportedEncodingException {
        HttpResponseStatus httpState = HttpResponseStatus.OK;
        ByteBuf returnContent = Unpooled.wrappedBuffer((byte[])responseContent.getBytes(encoding));
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, httpState, returnContent);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)("text/plain; charset=" + encoding));
        response.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, response.content().readableBytes());
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)encoding);
        cd.setTimeInMillis(System.currentTimeMillis());
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        response.headers().set((CharSequence)new AsciiString((CharSequence)"Date"), (Object)sdf.format(cd.getTime()));
        if (keepAlive) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            ChannelFuture s = channel.writeAndFlush((Object)response);
            return s.isSuccess();
        }
        channel.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        return false;
    }

    public static void sendRedirect(ChannelHandlerContext ctx, HttpRequest httpRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.valueOf((String)"application/octet-stream")));
        String http = "http";
        if ("true".equals(ishttps)) {
            http = "https";
        }
        ResponseEntity response = restTemplate.exchange(http + "://127.0.0.1:" + port + httpRequest.uri(), HttpMethod.GET, new HttpEntity((MultiValueMap)headers), byte[].class, new Object[0]);
        byte[] result = (byte[])response.getBody();
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])result);
        DefaultFullHttpResponse outResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, byteBuf);
        outResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/octet-stream; charset=UTF-8");
        outResponse.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, outResponse.content().readableBytes());
        cd.setTimeInMillis(System.currentTimeMillis());
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        outResponse.headers().set((CharSequence)new AsciiString((CharSequence)"Date"), (Object)sdf.format(cd.getTime()));
        if (!HttpUtil.isKeepAlive((HttpMessage)httpRequest)) {
            ctx.channel().write((Object)outResponse).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            outResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            ChannelFuture s = ctx.channel().writeAndFlush((Object)outResponse);
            s.isSuccess();
        }
    }

    public static void getResourceFile(ChannelHandlerContext ctx, HttpRequest httpRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.valueOf((String)"application/octet-stream")));
        String uri = httpRequest.uri();
        if (uri.contains("/iclock/upload/ins/adpic")) {
            uri = uri.replaceFirst("/iclock", "");
        }
        byte[] result = DeviceDataUtil.File2byte(FileUtil.getLocalFullPath((String)uri));
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])result);
        DefaultFullHttpResponse outResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, byteBuf);
        outResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/octet-stream; charset=UTF-8");
        outResponse.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, outResponse.content().readableBytes());
        cd.setTimeInMillis(System.currentTimeMillis());
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        outResponse.headers().set((CharSequence)new AsciiString((CharSequence)"Date"), (Object)sdf.format(cd.getTime()));
        if (!HttpUtil.isKeepAlive((HttpMessage)httpRequest)) {
            ctx.channel().write((Object)outResponse).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            outResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            ChannelFuture s = ctx.channel().writeAndFlush((Object)outResponse);
            s.isSuccess();
        }
    }

    static {
        log = Logger.getLogger(PushResponse.class);
        sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        cd = Calendar.getInstance();
    }
}

