/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccTransactionDoorPersonRemote;
import com.zkteco.zkbiosecurity.acc.service.AccPersonService;
import com.zkteco.zkbiosecurity.acc.service.AccTransactionService;
import com.zkteco.zkbiosecurity.acc.vo.AccTransactionDoorPersonItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccTransactionDoorPersonController
extends ExportController
implements AccTransactionDoorPersonRemote {
    @Autowired
    private AccTransactionService accTransactionService;
    @Autowired
    private AccPersonService accPersonService;

    @RequiresPermissions(value={"acc:transactionByDoor"})
    public ModelAndView index() {
        return new ModelAndView("acc/transactionPerson/accTransactionPerson");
    }

    @RequiresPermissions(value={"acc:transactionByDoor:refresh"})
    public DxGrid list(AccTransactionDoorPersonItem condition) {
        Pager pager = this.accPersonService.getDoorPerson(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"acc:transactionByDoor:del"})
    public ZKResultMsg del(String ids) {
        this.accTransactionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:transactionByDoor:export"})
    @LogRequest(module="acc_module", object="acc_leftMenu_searchByDoor", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        String doorId = request.getParameter("doorId");
        AccTransactionDoorPersonItem accTransactionDoorPersonItem = new AccTransactionDoorPersonItem();
        if (StringUtils.isNotBlank((CharSequence)doorId)) {
            accTransactionDoorPersonItem.setDoorId(doorId);
        }
        List itemList = this.accPersonService.getDoorPersonItemData(accTransactionDoorPersonItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, AccTransactionDoorPersonItem.class);
    }
}

