/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceEventService;
import com.zkteco.zkbiosecurity.acc.service.AccRTMonitorService;
import com.zkteco.zkbiosecurity.acc.utils.AccEnumUtil;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceEventItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.stereotype.Controller;

@Controller
public class AccRTMonitorWSController {
    @Autowired
    private AccRTMonitorService accRTMonitorService;
    @Autowired
    private AccDeviceEventService accDeviceEventService;

    @MessageMapping(value={"/accRTMonitor/getEventData"})
    @SendTo(value={"/topic/accRTMonitor/getEventData"})
    public Object getEventData(String _params) {
        return null;
    }

    @MessageMapping(value={"/accRTMonitor/getDevState"})
    @SendTo(value={"/topic/accRTMonitor/getDevState"})
    public Object getDevState(String params) {
        int connect;
        int i;
        JSONObject paramJson = JSONObject.parseObject((String)params);
        String areaIds = paramJson.containsKey((Object)"areaIds") ? paramJson.getString("areaIds") : "";
        JSONObject data = new JSONObject();
        JSONArray stateArray = null;
        JSONArray doorStates = new JSONArray();
        JSONArray auxInStates = new JSONArray();
        JSONArray auxOutStates = new JSONArray();
        JSONObject dev = null;
        JSONObject devState = (JSONObject)this.accRTMonitorService.getDevStateData(areaIds).getData();
        stateArray = devState.getJSONArray("doorState");
        if (Objects.nonNull(stateArray) && stateArray.size() > 0) {
            for (i = 0; i < stateArray.size(); ++i) {
                JSONObject door = stateArray.getJSONObject(i);
                dev = this.putDoorDataToMonitor(door);
                doorStates.add((Object)dev);
            }
            data.put("doorStates", (Object)doorStates);
        }
        if (Objects.nonNull(stateArray = devState.getJSONArray("auxInState")) && stateArray.size() > 0) {
            for (i = 0; i < stateArray.size(); ++i) {
                JSONObject auxIn = stateArray.getJSONObject(i);
                connect = auxIn.getIntValue("connect");
                auxIn.put("image", (Object)AccEnumUtil.AuxInImage.getValue(connect));
                auxInStates.add((Object)auxIn);
            }
            data.put("auxInStates", (Object)auxInStates);
        }
        if (Objects.nonNull(stateArray = devState.getJSONArray("auxOutState")) && stateArray.size() > 0) {
            for (i = 0; i < stateArray.size(); ++i) {
                JSONObject auxOut = stateArray.getJSONObject(i);
                connect = auxOut.getIntValue("connect");
                auxOut.put("image", (Object)AccEnumUtil.AuxOutImage.getValue(connect));
                auxOutStates.add((Object)auxOut);
            }
            data.put("auxOutStates", (Object)auxOutStates);
        }
        return data;
    }

    private JSONObject putDoorDataToMonitor(JSONObject door) {
        JSONObject data = new JSONObject();
        int sensor = door.getIntValue("sensor");
        int relay = door.getIntValue("relay");
        int alarm = door.getIntValue("alarm");
        int connect = door.getIntValue("connect");
        short alarmLevel = door.getShortValue("alarmLevel");
        int doorState = door.getIntValue("doorState");
        boolean isNewAccess = door.getBooleanValue("isNewAccess");
        String alarmValue = AccEnumUtil.Alarm.getValue(doorState, alarmLevel, alarm);
        data.put("id", (Object)door.getString("id"));
        data.put("areaId", (Object)door.getString("areaId"));
        data.put("devAlias", (Object)door.getString("devAlias"));
        data.put("devSn", (Object)door.getString("devSn"));
        data.put("no", (Object)door.getString("no"));
        data.put("name", (Object)door.getString("name"));
        data.put("connect", (Object)connect);
        data.put("sensor", (Object)(StringUtils.isNotBlank((CharSequence)AccEnumUtil.Sensor.getValue(doorState, sensor)) ? AccEnumUtil.Sensor.getValue(doorState, sensor) : ""));
        data.put("relay", (Object)(StringUtils.isNotBlank((CharSequence)AccEnumUtil.Relay.getValue(doorState, relay)) ? AccEnumUtil.Relay.getValue(doorState, relay) : ""));
        data.put("alarm", (Object)(StringUtils.isNotBlank((CharSequence)alarmValue) ? alarmValue : ""));
        if (isNewAccess) {
            alarmLevel = 0;
        }
        data.put("image", (Object)AccEnumUtil.DoorImage.getValue(doorState, connect, alarmLevel, alarm, relay, sensor));
        data.put("lockDisplay", (Object)door.getString("lockDisplay"));
        data.put("opDisplay", (Object)(doorState == 1 || doorState == 3 ? "inline" : "none"));
        if (connect == 0) {
            data.put("audio", (Object)"/public/media/sound/alarm.wav");
        } else if (alarm > 0 && !door.getBoolean("isDisableAudio").booleanValue()) {
            data.put("audio", (Object)"/public/media/sound/alarm.wav");
        }
        return data;
    }

    private String getAlarmAudioPath(String alarmName, String doorId) {
        String alarmAudioPath = "";
        if (!I18nUtil.i18nCode((String)"common_none", (Object[])new Object[0]).equals(alarmName)) {
            if (I18nUtil.i18nCode((String)"acc_rtMonitor_duressOpen", (Object[])new Object[0]).equals(alarmName) || I18nUtil.i18nCode((String)"acc_rtMonitor_duressFingerOpen", (Object[])new Object[0]).equals(alarmName) || I18nUtil.i18nCode((String)"acc_rtMonitor_duressPwdOpen", (Object[])new Object[0]).equals(alarmName)) {
                alarmName = I18nUtil.i18nCode((String)"acc_newEventNo_101", (Object[])new Object[0]);
            } else if (I18nUtil.i18nCode((String)"acc_rtMonitor_tamper", (Object[])new Object[0]).equals(alarmName)) {
                alarmName = I18nUtil.i18nCode((String)"acc_eventNo_100", (Object[])new Object[0]);
            } else if (I18nUtil.i18nCode((String)"acc_rtMonitor_duressOpen", (Object[])new Object[0]).equals(alarmName)) {
                alarmName = I18nUtil.i18nCode((String)"acc_newEventNo_101", (Object[])new Object[0]);
            } else if (I18nUtil.i18nCode((String)"acc_rtMonitor_alarm", (Object[])new Object[0]).equals(alarmName)) {
                return "/public/media/sound/alarm.wav";
            }
            List accDeviceEvents = this.accDeviceEventService.getItemsByNameAndDoorId(alarmName, doorId);
            if (Objects.nonNull(accDeviceEvents) && Objects.nonNull(accDeviceEvents.get(0)) && StringUtils.isNotBlank((CharSequence)((AccDeviceEventItem)accDeviceEvents.get(0)).getBaseMediaFilePath())) {
                alarmAudioPath = ((AccDeviceEventItem)accDeviceEvents.get(0)).getBaseMediaFilePath();
            }
        }
        return alarmAudioPath;
    }
}

