/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccPersonLastAddrRemote;
import com.zkteco.zkbiosecurity.acc.service.AccPersonLastAddrService;
import com.zkteco.zkbiosecurity.acc.vo.AccPersonLastAddrItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccPersonLastAddrController
extends ExportController
implements AccPersonLastAddrRemote {
    @Autowired
    private AccPersonLastAddrService accPersonLastAddrService;

    @RequiresPermissions(value={"acc:personLastAddr"})
    public ModelAndView index() {
        return new ModelAndView("acc/personLastAddr/accPersonLastAddr");
    }

    @RequiresPermissions(value={"acc:personLastAddr:refresh"})
    public DxGrid list(AccPersonLastAddrItem condition) {
        Pager pager = this.accPersonLastAddrService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"acc:personLastAddr:del"})
    public ZKResultMsg del(String ids) {
        this.accPersonLastAddrService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:personLastAddr:del"})
    @LogRequest(module="acc_module", object="acc_trans_lastAddr", opType="common_op_clearData", opContent="common_op_clearData")
    public ZKResultMsg clearData() {
        this.accPersonLastAddrService.deleteAllData();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:personLastAddr:export"})
    @LogRequest(module="acc_module", object="acc_trans_lastAddr", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        AccPersonLastAddrItem accPersonLastAddrItem = new AccPersonLastAddrItem();
        this.setConditionValue((BaseItem)accPersonLastAddrItem);
        List itemList = this.accPersonLastAddrService.getItemData(AccPersonLastAddrItem.class, (BaseItem)accPersonLastAddrItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, AccPersonLastAddrItem.class);
    }

    public ZKResultMsg getPersonLastAddrByPin(String pin) {
        ZKResultMsg res = new ZKResultMsg();
        Map retMap = this.accPersonLastAddrService.getPersonLastAddrByPin(pin, WebContextUtil.getCurrentSessionId());
        res.setData((Object)retMap);
        return res;
    }
}

