/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccMapPosRemote;
import com.zkteco.zkbiosecurity.acc.service.AccMapPosService;
import com.zkteco.zkbiosecurity.acc.vo.AccMapPosItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccMapPosController
extends BaseController
implements AccMapPosRemote {
    @Autowired
    private AccMapPosService accMapPosService;

    @RequiresPermissions(value={"acc:accMapPos"})
    public ModelAndView index() {
        return new ModelAndView("acc/accMapPos/accMapPos");
    }

    @RequiresPermissions(value={"acc:accMapPos:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.accMapPosService.getItemById(id));
        }
        return new ModelAndView("acc/accMapPos/editAccMapPos");
    }

    @RequiresPermissions(value={"acc:baseMapPos:edit"})
    @LogRequest(module="acc_module", object="acc_leftMenu_electronicMap", opType="acc_accMapPos_edit", requestParams={"id"}, opContent="acc_accMapPos_id")
    public ZKResultMsg save(AccMapPosItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accMapPosService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:accMapPos:refresh"})
    public DxGrid list(AccMapPosItem codition) {
        Pager pager = this.accMapPosService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:map:delEntity"})
    @LogRequest(module="acc_module", object="acc_leftMenu_electronicMap", opType="base_map_delEntity", requestParams={"name"}, opContent="common_dev_name")
    public ZKResultMsg del(String ids) {
        this.accMapPosService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getEntityWidthByMapId(String mapId) {
        AccMapPosItem accMapPosItem;
        double width = 40.0;
        AccMapPosItem tmpAccMapPosItem = new AccMapPosItem();
        tmpAccMapPosItem.setMapId(mapId);
        List itemList = this.accMapPosService.getByCondition(tmpAccMapPosItem);
        if (!itemList.isEmpty() && (accMapPosItem = (AccMapPosItem)itemList.get(0)).getWidth() != null) {
            width = accMapPosItem.getWidth();
        }
        return new ZKResultMsg((Object)width);
    }
}

