/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccInterlockRemote;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.service.AccInterlockService;
import com.zkteco.zkbiosecurity.acc.vo.AccInterlockItem;
import com.zkteco.zkbiosecurity.acc.vo.AccInterlockSelectDeviceItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccInterlockController
extends BaseController
implements AccInterlockRemote {
    @Autowired
    private AccInterlockService accInterlockService;
    @Autowired
    private AccDeviceService accDeviceService;

    @RequiresPermissions(value={"acc:interlock"})
    public ModelAndView index() {
        return new ModelAndView("acc/interlock/accInterlock");
    }

    @RequiresPermissions(value={"acc:interlock:add", "acc:interlock:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.accInterlockService.getItemById(id));
        }
        return new ModelAndView("acc/interlock/editAccInterlock");
    }

    @RequiresPermissions(value={"acc:interlock:add", "acc:interlock:edit"})
    @LogRequest(module="acc_module", object="acc_eventNo_25", opType="common_op_edit", requestParams={"deviceName"}, opContent="common_dev_name")
    public ZKResultMsg save(AccInterlockItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accInterlockService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:interlock:refresh"})
    public DxGrid list(AccInterlockItem codition) {
        String authAreaIds = this.accDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            codition.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.accInterlockService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        List accInterlockItemList = pager.getData();
        accInterlockItemList.forEach(accInterlockItem -> accInterlockItem.setInterlockRuleShow(this.accInterlockService.convertInterlockRule(accInterlockItem.getId())));
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:interlock:del"})
    @LogRequest(module="acc_module", object="acc_eventNo_25", opType="common_op_del", requestParams={"deviceNames"}, opContent="common_dev_name")
    public ZKResultMsg del(String ids) {
        this.accInterlockService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getRule(String deviceId) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        ArrayList<SelectItem> selectItemList = new ArrayList<SelectItem>();
        Map doorMap = this.accInterlockService.getRule(deviceId);
        if (doorMap.size() > 1) {
            SelectItem selectItem = new SelectItem();
            selectItem.setValue("1");
            String rule1 = I18nUtil.i18nCode((String)"acc_interlock_mode1Or2", (Object[])new Object[]{doorMap.get(1), doorMap.get(2)});
            selectItem.setText((Object)rule1);
            selectItemList.add(selectItem);
        }
        if (doorMap.size() == 4) {
            SelectItem selectItem2 = new SelectItem();
            selectItem2.setValue("2");
            String rule2 = I18nUtil.i18nCode((String)"acc_interlock_mode1Or2", (Object[])new Object[]{doorMap.get(3), doorMap.get(4)});
            selectItem2.setText((Object)rule2);
            selectItemList.add(selectItem2);
            SelectItem selectItem3 = new SelectItem();
            selectItem3.setValue("3");
            String rule3 = I18nUtil.i18nCode((String)"acc_interlock_mode3", (Object[])new Object[]{doorMap.get(1), doorMap.get(2), doorMap.get(3)});
            selectItem3.setText((Object)rule3);
            selectItemList.add(selectItem3);
            SelectItem selectItem4 = new SelectItem();
            selectItem4.setValue("4");
            String rule4 = I18nUtil.i18nCode((String)"acc_interlock_mode4", (Object[])new Object[]{doorMap.get(1), doorMap.get(2), doorMap.get(3), doorMap.get(4)});
            selectItem4.setText((Object)rule4);
            selectItemList.add(selectItem4);
            SelectItem selectItem5 = new SelectItem();
            selectItem5.setValue("5");
            String rule5 = I18nUtil.i18nCode((String)"acc_interlock_mode5", (Object[])new Object[]{doorMap.get(1), doorMap.get(2), doorMap.get(3), doorMap.get(4)});
            selectItem5.setText((Object)rule5);
            selectItemList.add(selectItem5);
        }
        zkResultMsg.setData(selectItemList);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public DxGrid selectDevicelist(AccInterlockSelectDeviceItem codition) {
        String filterDevId = this.accInterlockService.getDevIdWithInterlock();
        if (StringUtils.isBlank((CharSequence)codition.getSelectId())) {
            codition.setSelectId("-1");
        }
        if (codition.getType().equals("noSelected")) {
            if (StringUtils.isNotBlank((CharSequence)filterDevId)) {
                filterDevId = codition.getSelectId() + "," + filterDevId;
                codition.setSelectId(filterDevId);
            }
            codition.setSelectDeviceIdsNotIn(codition.getSelectId());
        } else if (codition.getType().equals("selected")) {
            codition.setSelectDeviceIdsIn(codition.getSelectId());
        }
        String authAreaIds = this.accDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            codition.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.accDeviceService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }
}

