/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.zkteco.zkbiosecurity.acc.remote.AccHolidayRemote;
import com.zkteco.zkbiosecurity.acc.service.AccHolidayService;
import com.zkteco.zkbiosecurity.acc.vo.AccHolidayItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccHolidayController
extends BaseController
implements AccHolidayRemote {
    private final int MAX_HOLIDAY_COUNT_PER_TYPE = 32;
    @Autowired
    private AccHolidayService accHolidayService;

    @RequiresPermissions(value={"acc:holiday"})
    public ModelAndView index() {
        return new ModelAndView("acc/holiday/accHoliday");
    }

    @RequiresPermissions(value={"acc:holiday:edit", "acc:holiday:add"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("tempAccHoliday", (Object)this.accHolidayService.getItemById(id));
        }
        return new ModelAndView("acc/holiday/editAccHoliday");
    }

    @RequiresPermissions(value={"acc:holiday:edit", "acc:holiday:add"})
    @LogRequest(module="acc_module", object="common_leftMenu_holiday", opType="common_op_edit", requestParams={"name"}, opContent="common_holiday_name")
    public ZKResultMsg save(AccHolidayItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accHolidayService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:holiday:refresh"})
    public DxGrid list(AccHolidayItem codition) {
        Pager pager = this.accHolidayService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:holiday:del"})
    @LogRequest(module="acc_module", object="common_leftMenu_holiday", opType="common_op_del", requestParams={"names"}, opContent="common_holiday_name")
    public ZKResultMsg del(String ids) {
        this.accHolidayService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String isExist(String name) {
        return this.accHolidayService.isExist(name);
    }

    public ZKResultMsg dataValid(AccHolidayItem accHolidayItem) {
        String result = "true";
        Date nowDate = new Date();
        int holidayCount = this.accHolidayService.getByCondition(new AccHolidayItem()).size();
        if (StringUtils.isNotBlank((CharSequence)accHolidayItem.getId())) {
            --holidayCount;
        }
        if (holidayCount == 32) {
            result = I18nUtil.i18nCode((String)"common_holiday_countError", (Object[])new Object[]{String.valueOf(32)});
            return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)result));
        }
        Date startDate = DateUtil.stringToDate((String)accHolidayItem.getStartDate(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
        Date endDate = DateUtil.stringToDate((String)accHolidayItem.getEndDate(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
        if (startDate.getTime() > endDate.getTime()) {
            result = I18nUtil.i18nCode((String)"common_startEndDateCompare", (Object[])new Object[0]);
            return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)result));
        }
        if (DateUtil.getYear((Date)endDate) < DateUtil.getYear((Date)nowDate) || DateUtil.getYear((Date)startDate) < DateUtil.getYear((Date)nowDate) || DateUtil.getYear((Date)endDate) - DateUtil.getYear((Date)startDate) != 0) {
            result = I18nUtil.i18nCode((String)"common_holiday_fillError3", (Object[])new Object[0]);
            return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)result));
        }
        List<Date> currentDate = this.getDateBetween(startDate, endDate);
        List<Date> existDate = this.getAllHolidaysDate(accHolidayItem);
        for (Date date : currentDate) {
            if (!existDate.contains(date)) continue;
            result = I18nUtil.i18nCode((String)"common_holiday_fillError4", (Object[])new Object[]{DateUtil.dateToString((Date)date, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD)});
            return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)result));
        }
        ArrayList monthAndDay = Lists.newArrayList();
        for (Date date : currentDate) {
            monthAndDay.add(DateUtil.getMonth((Date)date) + "-" + DateUtil.getDay((Date)date));
        }
        Set<List<String>> set = this.getAllMonthDay(accHolidayItem);
        for (Date date : currentDate) {
            if (!set.contains(monthAndDay)) continue;
            result = I18nUtil.i18nCode((String)"common_holiday_fillError5", (Object[])new Object[]{String.valueOf(DateUtil.getMonth((Date)date)), String.valueOf(DateUtil.getDay((Date)date))});
            return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)result));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)result));
    }

    public List<Date> getDateBetween(Date startDate, Date endDate) {
        ArrayList dateList = Lists.newArrayList();
        int delta = (int)((endDate.getTime() - startDate.getTime()) / 1000L / 24L / 60L / 60L);
        for (int d = 0; d < delta + 1; ++d) {
            dateList.add(new Date(startDate.getTime() + 86400000L * (long)d));
        }
        return dateList;
    }

    public List<Date> getAllHolidaysDate(AccHolidayItem accHolidayItem) {
        HashSet allDate = Sets.newHashSet();
        ArrayList holidayList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)accHolidayItem.getId())) {
            AccHolidayItem tempHoliday = new AccHolidayItem();
            tempHoliday.setNotInId(accHolidayItem.getId());
            holidayList.addAll(this.accHolidayService.getByCondition(tempHoliday));
        } else {
            List holidays = this.accHolidayService.getByCondition(new AccHolidayItem());
            if (holidays != null && holidays.size() > 0) {
                holidayList.addAll(holidays);
            }
        }
        holidayList.stream().forEach(holiday -> {
            Date startDate = DateUtil.stringToDate((String)holiday.getStartDate(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
            Date endDate = DateUtil.stringToDate((String)holiday.getEndDate(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
            allDate.addAll(this.getDateBetween(startDate, endDate));
        });
        return Lists.newArrayList((Iterable)allDate);
    }

    public Set<List<String>> getAllMonthDay(AccHolidayItem accHolidayItem) {
        AccHolidayItem tempHoliday = null;
        HashSet allDate = Sets.newHashSet();
        ArrayList allMonthDay = Lists.newArrayList();
        ArrayList allHolidaysList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)accHolidayItem.getId())) {
            if (!accHolidayItem.getIsLoopByYear().booleanValue()) {
                tempHoliday = new AccHolidayItem();
                tempHoliday.setNotInId(accHolidayItem.getId());
                tempHoliday.setIsLoopByYear(Boolean.valueOf(true));
                allHolidaysList.addAll(this.accHolidayService.getByCondition(tempHoliday));
            } else {
                tempHoliday = new AccHolidayItem();
                tempHoliday.setNotInId(accHolidayItem.getId());
                allHolidaysList.addAll(this.accHolidayService.getByCondition(tempHoliday));
            }
        } else if (!accHolidayItem.getIsLoopByYear().booleanValue()) {
            tempHoliday = new AccHolidayItem();
            tempHoliday.setIsLoopByYear(Boolean.valueOf(true));
            allHolidaysList.addAll(this.accHolidayService.getByCondition(tempHoliday));
        } else {
            allHolidaysList.addAll(this.accHolidayService.getByCondition(new AccHolidayItem()));
        }
        allHolidaysList.stream().forEach(holiday -> {
            Date startDate = DateUtil.stringToDate((String)holiday.getStartDate(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
            Date endDate = DateUtil.stringToDate((String)holiday.getEndDate(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
            allDate.addAll(this.getDateBetween(startDate, endDate));
        });
        allDate.stream().forEach(date -> {
            String monthAndDay = DateUtil.getMonth((Date)date) + "-" + DateUtil.getDay((Date)date);
            allMonthDay.add(monthAndDay);
        });
        return new HashSet<List<String>>(allMonthDay);
    }
}

