/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccFirstOpenRemote;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.service.AccDoorService;
import com.zkteco.zkbiosecurity.acc.service.AccFirstOpenService;
import com.zkteco.zkbiosecurity.acc.service.AccPersonService;
import com.zkteco.zkbiosecurity.acc.vo.AccFirstOpenItem;
import com.zkteco.zkbiosecurity.acc.vo.AccFirstOpenSelectDoorItem;
import com.zkteco.zkbiosecurity.acc.vo.AccPersonListNoCardItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccFirstOpenController
extends BaseController
implements AccFirstOpenRemote {
    @Autowired
    private AccFirstOpenService accFirstOpenService;
    @Autowired
    private AccPersonService accPersonService;
    @Autowired
    private AccDeviceService accDeviceService;
    @Autowired
    private AccDoorService accDoorService;

    @RequiresPermissions(value={"acc:firstOpen"})
    public ModelAndView index() {
        return new ModelAndView("acc/firstOpen/accFirstOpen");
    }

    @RequiresPermissions(value={"acc:firstOpen:add", "acc:firstOpen:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.accFirstOpenService.getItemById(id));
        }
        return new ModelAndView("acc/firstOpen/editAccFirstOpen");
    }

    @RequiresPermissions(value={"acc:firstOpen:add", "acc:firstOpen:edit"})
    @LogRequest(module="acc_module", object="acc_leftMenu_firstOpen", opType="common_op_edit", requestParams={"doorName"}, opContent="acc_door_name")
    public ZKResultMsg save(AccFirstOpenItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accFirstOpenService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:firstOpen:refresh"})
    public DxGrid list(AccFirstOpenItem codition) {
        Pager pager = this.accFirstOpenService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:firstOpen:del"})
    @LogRequest(module="acc_module", object="acc_leftMenu_firstOpen", opType="common_op_del", requestParams={"doorNames"}, opContent="acc_door_name")
    public ZKResultMsg del(String ids) {
        this.accFirstOpenService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:firstOpen:addPerson"})
    @LogRequest(module="acc_module", object="acc_leftMenu_firstOpen", opType="pers_common_addPerson", requestParams={"doorName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg addPerson(String firstOpenId, String personIds, String deptIds) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)deptIds)) {
            personIds = this.accPersonService.getPersonIdsByDeptIds(deptIds);
        }
        if (StringUtils.isNotBlank((CharSequence)firstOpenId) && StringUtils.isNotBlank((CharSequence)personIds)) {
            ArrayList<String> personIdList = new ArrayList<String>(Arrays.asList(personIds.split(",")));
            zkResultMsg = this.accFirstOpenService.addPerson(firstOpenId, personIdList);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequiresPermissions(value={"acc:firstOpen:delPerson"})
    @LogRequest(module="acc_module", object="acc_leftMenu_firstOpen", opType="pers_common_delPerson", requestParams={"doorName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg delPerson(String firstOpenId, String personIds) {
        ZKResultMsg zkResultMsg = this.accFirstOpenService.delPerson(firstOpenId, personIds);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequiresPermissions(value={"acc:firstOpen:refresh"})
    public DxGrid personList(AccPersonListNoCardItem codition) {
        codition.setModelType("ACC_FIRSTOPEN");
        Pager pager = this.accPersonService.getPersonNoCardItemList(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public DxGrid selectDoorlist(AccFirstOpenSelectDoorItem codition) {
        List doorIdList = this.accDoorService.getDoorIdAsReader();
        if (StringUtils.isBlank((CharSequence)codition.getSelectId())) {
            codition.setSelectId("-1");
        }
        if (codition.getType().equals("noSelected")) {
            if (doorIdList != null && doorIdList.size() > 0) {
                codition.setSelectId(codition.getSelectId() + "," + StringUtils.join((Iterable)doorIdList, (String)","));
            }
            codition.setSelectDoorIdsNotIn(codition.getSelectId());
        } else if (codition.getType().equals("selected")) {
            codition.setSelectDoorIdsIn(codition.getSelectId());
        }
        String authAreaIds = this.accDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            codition.setAuthAreaIdIn(authAreaIds);
        }
        codition.setEnabled(Boolean.valueOf(true));
        Pager pager = this.accFirstOpenService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }
}

