/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.security.xss;

import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(XssHttpServletRequestWrapper.class);
    private static String keyOne = "insert|select|delete|update|drop|truncate|declare";
    private static String keyTwo = "and|or";
    private static String keyFun = "exec|count|chr|mid|char|avg|sum|min|max|cast|convert|lower|upper|trim|ltrim|rtrim";
    private static String keySym = "*|%|--|+";
    private static Set<String> keyOneSet = null;
    private static Set<String> keyTwoSet = null;
    private static Set<String> keyFunSet = null;
    private static Set<String> keySymSet = null;
    private static Pattern keyPattern1;
    private static Pattern keyPattern2;
    private String currentUrl;
    private byte[] body;
    private Map<String, String[]> parameterMap;

    private static Set<String> convertStringToSet(String str) {
        String[] keyStr;
        HashSet<String> ret = new HashSet<String>(0);
        for (String key : keyStr = str.split("\\|")) {
            ret.add(key);
        }
        return ret;
    }

    private boolean isPlusOperate(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String base64Pattern;
            boolean isBase64 = (value = value.trim()).matches(base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$");
            if (isBase64) {
                return false;
            }
            if (value.startsWith("+")) {
                return false;
            }
            if (keyPattern1.matcher(value).find()) {
                return true;
            }
            if (value.length() < 200 && keyPattern2.matcher(value).find()) {
                return true;
            }
        }
        return false;
    }

    public XssHttpServletRequestWrapper(HttpServletRequest servletRequest) {
        super(servletRequest);
        if (StringUtils.isNotBlank((CharSequence)this.getHeader("X-Forwarded-For")) && "'".equals(this.getHeader("X-Forwarded-For"))) {
            throw new ZKBusinessException("common_xss_error_info");
        }
        this.currentUrl = servletRequest.getRequestURI();
        this.parameterMap = servletRequest.getParameterMap();
        this.body = XssHttpServletRequestWrapper.readAsChars(servletRequest).getBytes(Charset.forName("UTF-8"));
    }

    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        if (value == null) {
            return null;
        }
        return this.cleanXSS(parameter, value);
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = this.cleanXSS(parameter, values[i]);
        }
        return encodedValues;
    }

    public Map<String, String[]> getParameterMap() {
        Map values = super.getParameterMap();
        if (values == null) {
            return null;
        }
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (String key : values.keySet()) {
            String encodedKey = this.cleanXSS(key, key);
            int count = ((String[])values.get(key)).length;
            String[] encodedValues = new String[count];
            for (int i = 0; i < count; ++i) {
                encodedValues[i] = this.cleanXSS(key, ((String[])values.get(key))[i]);
            }
            result.put(encodedKey, encodedValues);
        }
        return result;
    }

    private String cleanXSS(String parameter, String valueP) {
        if (StringUtils.isBlank((CharSequence)valueP)) {
            return "";
        }
        if (StringUtils.isNotBlank((CharSequence)parameter) && !parameter.matches("[\\w$\\.]+") && !parameter.matches("([\\w$\\.]+(\\[\\d+\\])+[\\w$\\.]*)+")) {
            throw new ZKBusinessException("common_xss_error_info");
        }
        String value = valueP;
        if (value.contains("+") && this.isPlusOperate(value)) {
            throw new ZKBusinessException("common_xss_error_info");
        }
        try {
            value = URLDecoder.decode(value, "utf-8");
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        if (this.isVaildHtml(value)) {
            throw new ZKBusinessException("common_xss_error_info");
        }
        value = this.cleanSqlKeyWords(parameter, value);
        return valueP;
    }

    private boolean isVaildHtml(String value) {
        ArrayList<String> regexs = new ArrayList<String>();
        regexs.add("<([^>]*)>");
        regexs.add("<script>(.*?)</script>");
        regexs.add("(href|src)[\r\n]*=[\r\n]*\\'(.*?)");
        regexs.add("(href|src)[\r\n]*=[\r\n]*\\\"(.*?)");
        regexs.add("(window\\[\"location\"\\]|window\\['location'\\]|location)[\\s]*=(.*)");
        regexs.add("onmouse(over|down|out|move|up|wheel)[\\s]*=(.*)");
        regexs.add("(onclick|ondblclick|onsubmit|onblur|onchange|onfocus)[\\s]*=(.*)");
        regexs.add("alert[\\s]*\\((.*?)\\)");
        regexs.add(":[\\s]*alert");
        regexs.add("</script>");
        regexs.add("<script(.*?)>");
        regexs.add("eval\\((.*?)\\)");
        regexs.add("function[\\s]*\\((.*?)\\)");
        regexs.add("(;|=)[\\s]*new[\\s]+");
        regexs.add("expression\\((.*?)\\)");
        regexs.add("javascript:");
        regexs.add("vbscript:");
        regexs.add("[\\\"\\'][\\s]*javascript:(.*)[\\\"\\']");
        regexs.add("onload(.*?)=");
        regexs.add("<iframe>(.*?)</iframe>");
        regexs.add("</iframe>");
        regexs.add("<iframe(.*?)>");
        regexs.add("<frame>(.*?)</frame>");
        regexs.add("</frame>");
        regexs.add("<frame(.*?)>");
        regexs.add("<a>(.*?)</a>");
        regexs.add("</a>");
        regexs.add("<a(.*?)>");
        regexs.add("((like|and|or|xor|not|rlike)[\\s]*[%'])|([%'][\\s]*(like|and|or|xor|not|rlike)[\\W]+)");
        for (String regex : regexs) {
            Pattern scriptPattern = Pattern.compile(regex, 42);
            if (!scriptPattern.matcher(value).find()) continue;
            log.error(this.currentUrl + " error string = " + value);
            return true;
        }
        return false;
    }

    private String cleanSqlKeyWords(String param, String value) {
        String paramValue = value;
        if (StringUtils.isNotBlank((CharSequence)paramValue)) {
            if (paramValue.contains("||")) {
                throw new ZKBusinessException("common_xss_error_info");
            }
            for (String keyword : keyOneSet) {
                if (!Pattern.compile(keyword + "([\\s]+|[+])", 2).matcher(paramValue).find()) continue;
                throw new ZKBusinessException("common_xss_error_info");
            }
            for (String keyword : keyTwoSet) {
                if (!Pattern.compile("[\\s]+" + keyword + "[\\s]+([\\d]+|')", 2).matcher(paramValue).find()) continue;
                throw new ZKBusinessException("common_xss_error_info");
            }
            for (String keyword : keyFunSet) {
                if (!Pattern.compile(keyword + "[\\s]*\\(", 2).matcher(paramValue).find()) continue;
                throw new ZKBusinessException("common_xss_error_info");
            }
            for (String keyword : keySymSet) {
                if (!(keyword.equals("+") ? paramValue.contains("+") && this.isPlusOperate(paramValue) : (keyword.equals("*") ? paramValue.contains("*") && !Pattern.compile("[*]{2,}").matcher(paramValue).find() : paramValue.contains(keyword)))) continue;
                throw new ZKBusinessException("common_xss_error_info");
            }
        }
        return paramValue;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() throws IOException {
                return bais.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }

    public Enumeration<String> getParameterNames() {
        Vector<String> vector = new Vector<String>(this.parameterMap.keySet());
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAsChars(HttpServletRequest request) {
        String body = null;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            ServletInputStream inputStream = request.getInputStream();
            if (inputStream != null) {
                request.setCharacterEncoding("UTF-8");
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, "UTF-8"));
                char[] charBuffer = new char[128];
                int bytesRead = -1;
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            } else {
                stringBuilder.append("");
            }
        }
        catch (IOException ex) {
            log.error("readAsChars", (Throwable)ex);
        }
        finally {
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        body = stringBuilder.toString();
        return body;
    }

    static {
        keyOneSet = XssHttpServletRequestWrapper.convertStringToSet(keyOne);
        keyTwoSet = XssHttpServletRequestWrapper.convertStringToSet(keyTwo);
        keyFunSet = XssHttpServletRequestWrapper.convertStringToSet(keyFun);
        keySymSet = XssHttpServletRequestWrapper.convertStringToSet(keySym);
        keyPattern1 = Pattern.compile("[+][\\s]*(('(.)*)|([\\d]+[\\s]*(,|;)))");
        keyPattern2 = Pattern.compile("[\\d]+[\\s]*[+][\\s]*(-)?[\\s]*[\\d]+");
    }
}

